(ns leiningen.archaic.utils.io
  (:require [clojure.java.io :as io :only (file)]
            [clojure.tools.reader :as reader :only (read-string)]
            [leiningen.archaic.usage :as usage :only (run-task)]
            [leiningen.core.main :as main :only (abort)]
            [leiningen.core.project :as p :only (read)]
            [org.ozias.cljlibs.logging.logging :refer (fatalc)]))

(def ^:private nothidden 
  (proxy [java.io.FileFilter] []
    (accept [path] (not (.isHidden path)))))

(defn file-seq-nh [path]
  (tree-seq
   (fn [^java.io.File f] (. f (isDirectory)))
   (fn [^java.io.File d] (seq (. d (listFiles nothidden))))
   path))

(defn arcabort 
  ([message opts]
     (fatalc :red :bold (str \newline message \newline))
     (usage/run-task nil opts)
     (main/abort))
  ([throwable message opts]
     (fatalc throwable :red :bold (str \newline message \newline))
     (usage/run-task nil opts)
     (main/abort)))

(defn exists? [path]
  (if-let [path (and path (io/file path))]
    (and (.exists path) path)))

(defn directory? [path]
  (.isDirectory path))

(defn read-profiles-map [file args]
  (try
    (when-let [form (reader/read-string (slurp file))]
      (when-not (map? form)
        (throw (Exception. (str "'profiles.clj' is not a valid map" \newline))))
      form)
    (catch Exception ex
      (arcabort ex "Invalid 'profiles.clj'" args))))

(defn read-project-map [file args]
  (let [file (.getPath file)]
    (try
      (p/read file)
      (catch Exception ex
        (arcabort ex "Invalid 'project.clj' file" args)))))
