(ns leiningen.archaic.upgrade
  (:require (leiningen.archaic [check :as chk :only (run-task)]
                               [profiles :as prof :only (run-task)]
                               [proj :as proj :only (run-task)])))

(defn run-task [project {:keys [options arguments] :as opts}]
  (let [condarg  (second arguments)
        upopt (assoc-in opts [:options :upgrade] true)]
    (condp = condarg
      "profiles" (prof/run-task project upopt)
      "projects" (proj/run-task project upopt)
      (chk/run-task project upopt))))
