(ns leiningen.archaic.usage
  (:require [clojure.string :as str]
            [org.ozias.cljlibs.logging.logging :refer (reportc fatalc)]))

(defn- usage [options-summary]
  (reportc "")
  (reportc
   (->> ["Check for archaic artifacts in your project or user profile."
         ""
         "Usage: lein archaic [<options>] [<task>]"
         ""
         "Options:"
         options-summary
         ""
         "Tasks:"
         ""]
        (str/join \newline)))
  (reportc :green "  check" :reset "             Check for archaic artifacts in the current project and in")
  (reportc "                    ~/.lein/profiles.clj (default).")
  (reportc :green "  project" :reset "           Check for archaic artifacts in the current project.")
  (reportc :green "  profiles" :reset "          Check for archaic artifacts in ~/.lein/profiles.clj.")
  (reportc :green "  list <package>" :reset "    List all known versions of a given artifact")
  (reportc "                    (i.e. org.clojure/clojure). (NOT IMPLEMENTED)")
  (reportc :green "  list all" :reset "          List all known versions of all artifacts in the current project")
  (reportc "                    and in ~/.lein/profiles.clj. (NOT IMPLEMENTED)")
  (reportc :green "  upgrade" :reset "           Replace the archaic artifacts in the current project")
  (reportc "                    (project.clj) and in ~/.lein/profiles.clj. (NOT IMPLEMENTED)")
  (reportc :green "  upgrade project" :reset "   Replace the archaic artifacts in the current project. (NOT IMPLEMENTED)")
  (reportc :green "  upgrade profiles" :reset "  Replace the archaic artifacts in ~/.lein/profiles.clj. (NOT IMPLEMENTED)")
  (reportc :green "  usage" :reset "             Show lein-archaic usage information.")
  (reportc :green "  version" :reset "           Show lein-archaic version information.")
  (reportc ""))

(defn- error-msg [errors]
  (fatalc :red :bold "The following errors occurred while parsing your command:")
  (fatalc "")
  (fatalc (str/join \newline errors)))

(defn run-task [_ {:keys [options errors summary]}]
  (if errors 
    (error-msg errors)
    (usage summary)))
