(defproject org.ozias.cljlibs/shell "0.1.0-SNAPSHOT"
  :description "Clojure Shell Utilities"
  :url "https://github.com/CraZySacX/shell"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[com.taoensso/timbre "3.0.0-RC4"]
                 [me.raynes/conch "0.6.0"]
                 [org.clojure/clojure "1.5.1"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.6"]
                             [lein-marginalia "0.7.1"]
                             [org.clojars.cvillecsteele/lein-git-version "1.0.0"]]}}
  :middleware [lein-git-version.plugin/middleware]
  :aliases {"package" ["do" "clean," "install"]
            "docs" ["do" "doc," "marg" "--multi" "src/" "test/"]
            "most" ["do" "clean," "docs," "package"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "most," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
         :url "https://github.com/CraZySacX/shell"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.shell.version]
          :sources ["src" "test"]
          :src-dir-uri "http://github.com/CraZySacX/shell/blob/master/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.0-SNAPSHOT"}
  :git-version {:version-command ["git" "rev-parse" "--short" "HEAD"]
                :assoc-keys [[:version] [:manifest "Implementation-Version"]]})
