# shell
[conch]: https://github.com/Raynes/conch "Conch"
[bsimg]: https://travis-ci.org/CraZySacX/shell.png
[bslnk]: https://travis-ci.org/CraZySacX/shell
[endimg]: https://api.coderwall.com/crazysacx/endorsecount.png
[endlnk]: https://coderwall.com/crazysacx

Clojure Shell Utilities

I found myself using the [Conch][conch] library with 
a similar pattern every time I called it, so I've written a wrapper function to encapsulate
those similarities.

## Status
[![Build Status][bsimg]][bslnk]
[![endorse][endimg]][endlnk]

## Version
* Release: **0.2.2**
* Dev: **0.2.3-SNAPSHOT**

## Usage
Add the following to your dependencies in project.clj:

```Clojure
  :dependencies [...
                 [org.ozias.cljlibs/shell "0.2.2"]
                 ...]
```

Include the following in the file you wish to use shell:

```Clojure
(ns my.ns
    (:require [org.ozias.cljlibs.shell.shell :refer :all]))
```

### shell-cmd
Execute a shell command.

Called with a command vector ```["ls" "-al"]``` and an optional set of keys (note that :s and :verbose default to true)

    :basedir (dir)        - The directory you wish to run the command in
    :s       (true/false) - Produce the output streams as lazy sequences
    :verbose (true/false) - Output is the conch process map rather that stdout
    :out     (fn)         - Supply a two argument function that handles stdout
    :err     (fn)         - Supply a tow argumemt function that handles stderr
    :buffer  (:none or #) - The buffer size for the output sequence if s is true

#### Examples

```clojure
(require '[org.ozias.cljlibs.shell.shell :refer :all])

; List all files in your current directory
(shell-cmd ["ls" "-al"])

; List all files in your /tmp directory*
(shell-cmd ["ls" "-al"] :basedir "/tmp")

; two arg output function
(defn out [o _] (print o) (flush))

; List all files in your current directory and use out to handle output
(shell-cmd ["ls" "-al"] :out out :err out)
```

If you specify ```:verbose true``` the function will evaluate to a map of the following format (per conch):

```clojure
{:proc {:out (...), :in ..., :err ..., :process ..., 
        :exit-code ..., :stdout ..., :stderr ...}}
```

In general, you are most interested in ```:out``` and ```:exit-code```.  Note that ```:out``` 
will be a sequence, and ```:exit-code``` must be dereferenced to access the value.

### cmd->sshcmd
Translate the given command into a command executed via ssh.

If the target is localhost, or user@localhost, the command will be executed locally.

#### Examples

```clojure
(require '[org.ozias.cljlibs.shell.shell :refer :all])

; List all files in the /tmp directory for user@host
(let [ssh (cmd->sshcmd "user@host")]
  (-> ["ls" "-al"] ssh (shell-cmd :basedir "/tmp")))
```
