(ns org.ozias.cljlibs.shell.shell
  (:require [me.raynes.conch :refer [let-programs]]
            [org.ozias.cljlibs.utils.core :refer [assoc-if
                                                  localhost?]]))

(defn cmd->sshcmd
  "Given a target, evaluates to a function that takes a command vector
  as an argument.

  If the target is not a localhost target, [\"ssh\" target] will be
  prepended to the command vector."
  [target & sshopts]
  (if (localhost? target)
    (fn [cmd] cmd)
    (fn [cmd] (-> ["ssh" (vec sshopts) target]
                  (into cmd)
                  (flatten)
                  (vec)))))

(defn shell-cmd
  "Execute the given shell command.

  cmdv should be a vector of strings representing
  the command you wish to execute.
  [\"ls\" \"-al\"]

  If basedir is supplied, the command will be run in that directory."
  [cmdv & {:keys [basedir out err buffer verbose s] :or {verbose true s true}}]
  (if (and (seq cmdv) (vector? cmdv) (every? string? cmdv))
    (let [process-map (assoc-if {:seq s :verbose verbose}
                                :basedir basedir :out out
                                :err err :buffer buffer)]
      (let-programs [cmd (first cmdv)]
                    (apply cmd (conj (subvec cmdv 1) process-map))))))