semver
======
[semver]: http://semver.org "semver.org"
[bsimg]: https://travis-ci.org/CraZySacX/semver.png
[bslnk]: https://travis-ci.org/CraZySacX/semver
[endimg]: https://api.coderwall.com/crazysacx/endorsecount.png
[endlnk]: https://coderwall.com/crazysacx

Semantic version-ing comparison library for Clojure.  See
[semver.org][semver] for details about Semantic Versions.

## Status
[![Build Status][bsimg]][bslnk]
[![endorse][endimg]][endlnk]

## Version
* Release: **0.1.2**
* Dev: **0.1.3-SNAPSHOT**

## Usage
Add the following to your dependencies in project.clj.

```Clojure
  :dependencies [...
                 [org.ozias.cljlibs/semver "0.1.2"]
                 ...]
```

Include the following if you wish to use sever in a .clj file

```Clojure
(ns my.ns
    (:require [org.ozias.cljlibs.semver.semver :refer :all]))
```

If at the REPL, you can use the following

```Clojure
(require '[org.ozias.cljlibs.semver.semver :refer :all])
```
### semver?
```semver?``` checks if the given argument if a valid semantic version.  If the
 arg is not a valid semantic version ```semver?``` evaluates to nil.  If the
 arg is a valid semantic version ```semver?``` evaluates to a vector of the
 following format ```[{:major 1 :minor 0 :patch 0} pre-release buildmeta]```.
   Note that ```pre-release``` and ```buildmeta``` may be nil.

```Clojure
(semver? nil)
=> nil
(semver? "")
=> nil
(semver? [])
=> nil
(semver? "abc1023")
=> nil
(semver? "1.0")
=> nil
(semver? "1.0.a")
=> nil
(semver? "1.0.0")
=> [{:patch "0", :minor "0", :major "1"} nil nil]
(semver? "1.0.0-SNAPSHOT")
=> [{:patch "0", :minor "0", :major "1"} "SNAPSHOT" nil]
(semver? "1.0.0+20130322")
=> [{:patch "0", :minor "0", :major "1"} nil "20130322"]
(semver? "1.0.0-beta.2+20140322040533")
=> [{:patch "0", :minor "0", :major "1"} "beta.2" "20140322040533"]
```

### compare-versions
```compare-versions``` is meant to be used by sort to determine the
precedence of the two supplied arguments.

```Clojure
(compare-versions "1.0.0" "1.0.0")
=> 0
(compare-versions "1.0.0-rc.1" "1.0.0-rc.1")
=> 0
(compare-versions "1.0.0" "1.0.0-SNAPSHOT")
=> 1
(compare-versions "1.0.0-SNAPSHOT" "1.0.0")
=> -1
(compare-versions "1.0.0-SNAPSHOT" "1.0.0-rc.1")
=> 1
(sort compare-versions ["2.0.0" "1.0.1" "1.0.0-rc.1" "1.0.3" "1.0.0"])
;lowest to highest precedence
=> ("1.0.0-rc.1" "1.0.0" "1.0.1" "1.0.3" "2.0.0")
```