(defproject org.ozias.cljlibs/semver "0.1.1"
  :description "Semantic version-ing library for Clojure"
  :url "https://github.com/CraZySacX/semver"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.5.1"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[midje "1.6.0" :exclusions [org.clojure/clojure]]
                                  [org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.6"]
                             [lein-midje "3.1.3"]
                             [org.ozias.plugins/lein-git-version "1.1.0-alpha.2"]]}}
  :aliases {"package" ["do" "clean," "install"]
            "most" ["do" "clean," "doc," "package"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "most," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
        :url "https://github.com/CraZySacX/semver"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.semver.version]
          :sources ["src" "test"]
          :src-dir-uri "http://github.com/CraZySacX/semver/blob/0.1.1/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.1"}
  :git-version {:project {:cmd []
                          :fmt ["%s-%s.%s" :basever "alpha" 0]
                          :assoc-in-keys [[:version]]}
                :manifest {:cmd ["git" "rev-parse" "HEAD"]
                           :fmt ["%s+%s.%s" :basever :cmdver :date]
                           :assoc-in-keys [[:manifest "Implementation-Version"]]}})
