(ns org.ozias.cljlibs.scm.core
  (:require [clojure.data :refer (diff)]
            [environ.core :refer :all]
            [me.raynes.conch :refer (with-programs)]
            [org.ozias.cljlibs.utils.core :refer :all]))

(defmacro gen-scm-test-fn [scm]
  (let [test-fn-symbol (symbol (str scm "?"))]
    `(defn ~test-fn-symbol []
       (cond
        (or (linux?)(mac?)) (with-programs [~'which]
                              (if (not= "" (~'which ~scm))
                                ~scm))
        (windows?) (with-programs [~'where]
                     (if (not= "" (~'where ~scm))
                       ~scm))))))

(defmacro gen-base-scm-fn [scm]
  (let [scm-symbol (symbol scm)]
    `(defn ~scm-symbol [& {:keys [~'cmd ~'dir ~'verbose ~'seq ~'in ~'out ~'err ~'timeout ~'buffer]}]
       (with-programs [~scm-symbol]
         (fn [& ~'opts]
           (let [~'cmd (remove nil? (conj ~'opts ~'cmd))]
             (->> (assoc-if {} :dir ~'dir :verbose ~'verbose :seq ~'seq :in ~'in :out ~'out 
                            :err ~'err :timeout ~'timeout :buffer ~'buffer)
                  (conj (vec ~'cmd))
                  (apply ~scm-symbol))))))))

(defn ^:private gen-scm-fn [scm cmd]
  `(defn ~(symbol (str scm "-" cmd)) [& {:keys [~'dir ~'verbose ~'seq ~'in ~'out ~'err ~'timeout ~'buffer]}]
     (~(symbol scm) :cmd ~cmd :dir ~'dir :verbose ~'verbose :seq ~'seq
      :in ~'in :out ~'out :err ~'err :timeout ~'timeout :buffer ~'buffer)))

(defn gen-scm-fns [scm cmdv]
  `(do ~@(map (fn [cmd] (gen-scm-fn scm cmd)) cmdv)))

(defn check-cmds
  "check a command vector against the commands parsed
  from the help text"
  [cmdv parsed]
  (let [[a b _] (diff cmdv parsed)]
    (if (and (nil? a) (nil? b))
      "all commands supported"
      (assoc-if {} 
                :remove-from-cmdv (if (seq a) (filter string? a) a)
                :add-to-cmdv (if (seq b) (filter string? b) b)))))

(defn prscm [scmfn & args]
  (->> args 
       (apply (scmfn :seq true :verbose true))
       ((juxt :stdout :stderr))
       (map prseq)
       dorun))
