(ns org.ozias.cljlibs.scm.bzr
  (:require [clojure.string :refer (split trim)]
            [me.raynes.conch :refer (with-programs)]
            [org.ozias.cljlibs.scm.core :refer :all]))

(def bzr-cmdv
  ["add" "alias" "annotate" "bash-completion" "bind" "branch" "branches"
   "break-lock" "cat" "check" "checkout" "clean-tree" "commit" "config"
   "conflicts" "deleted" "diff" "dpush" "export" "fast-export" "fast-import"
   "fast-import-filter" "fast-import-info" "grep" "help" "ignore" "ignored"
   "info" "init" "init-repository" "join" "launchpad-login" "launchpad-mirror"
   "launchpad-open" "log" "lp-find-proposal" "lp-propose-merge" "ls" "merge"
   "missing" "mkdir" "mv" "nick" "pack" "ping" "plugins" "pull" "push"
   "reconcile" "reconfigure" "register-branch" "remerge" "remove"
   "remove-branch" "remove-tree" "renames" "resolve" "revert" "revno" "root"
   "send" "serve" "shelve" "sign-my-commits" "split" "status" "switch" "tag"
   "tags" "testament" "unbind" "uncommit" "unshelve" "update" "upgrade"
   "verify-signatures" "version" "version-info" "view" "whoami"])

(gen-scm-test-fn "bzr")

(defn bzr-help-parse []
  (if (bzr?)
    (->> (with-programs [bzr] (bzr "help" "commands" {:seq true}))
         (map #(split % #" "))
         (map first)
         (filter #(not= "" %))
         (sort))
    (list)))

(gen-base-scm-fn "bzr")
(defmacro gen-bzr-fns [] (gen-scm-fns "bzr" bzr-cmdv))
(gen-bzr-fns)
