# scm
I'm a big proponent of the [Reloaded](http://thinkrelevance.com/blog/2013/06/04/clojure-workflow-reloaded) workflow.
As a result, I like to get most of my work done at the REPL.  Including this project as a dev dependency allows me to interact with my scm tool from the REPL.

You can also use this to programatically interact with a repository.  See [Overbuild](https://github.com/CraZySacX/overbuild) for an example.

## Status
[![Build Status](https://travis-ci.org/CraZySacX/scm.png)](https://travis-ci.org/CraZySacX/scm)

## Version
* Release: **0.1.0**
* Dev: **0.1.1-SNAPSHOT**

## Usage
Add the following in the profiles section of your project.clj file:

```Clojure
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.namespace "0.2.4"]
                                  [org.ozias.cljlibs/scm "0.1.0"]]
```

Add the following to your dev/user.clj file:

```Clojure
(ns user
  (:require ...
            [clojure.tools.namespace.repl :refer (refresh refresh-all)]
            [org.ozias.cljlibs.scm.core :refer (prso prse)]
            [org.ozias.cljlibs.scm.git :refer :all]
            ...))
```

If you don't use dev/user.clj you can add the following to your project.clj

```Clojure
  :dependencies [...
                 [org.ozias.cljlibs/scm "0.1.0"]
                 ...]
```

Then at the REPL (if git is the scm you wish to interact with):

```Clojure
; The prso and prse functions are convenience functions that println the output
; sequence from stdout and stderr respectively.  They are not required.
(require '[org.ozias.cljlibs.scm.core :refer (prso prse)])
(require '[org.ozias.cljlibs.scm.git :refer :all])
```

## Example

![REPL Output](images/cider_output.png?raw=true)

## License

Copyright © 2014 Jason Ozias

Distributed under the MIT License
