(ns org.ozias.cljlibs.scm.git
  (:require [clojure.string :refer (split trim)]
            [me.raynes.conch :refer (with-programs)]
            [org.ozias.cljlibs.scm.core :refer :all]))

(def git-cmdv
  ["add" "add--interactive" "am" "annotate" "apply" "archimport" "archive"
   "bisect" "bisect--helper" "blame" "branch" "bundle" "cat-file" "check-attr"
   "check-ignore" "check-mailmap" "check-ref-format" "checkout" "checkout-index"
   "cherry" "cherry-pick" "citool" "clean" "clone" "column" "commit"
   "commit-tree" "config" "count-objects" "credential" "credential-cache"
   "credential-cache--daemon" "credential-gnome-keyring" "credential-store"
   "cvsexportcommit" "cvsimport" "cvsserver" "daemon" "describe" "diff"
   "diff-files" "diff-index" "diff-tree" "difftool" "difftool--helper"
   "fast-export" "fast-import" "fetch" "fetch-pack" "filter-branch"
   "fmt-merge-msg" "for-each-ref" "format-patch" "fsck" "fsck-objects"
   "gc" "get-tar-commit-id" "grep" "gui" "gui--askpass" "hash-object" "help"
   "http-backend" "http-fetch" "http-push" "imap-send" "index-pack" "init"
   "init-db" "instaweb" "log" "ls-files" "ls-remote" "ls-tree" "mailinfo"
   "mailsplit" "merge" "merge-base" "merge-file" "merge-index" "merge-octopus"
   "merge-one-file" "merge-ours" "merge-recursive" "merge-resolve" "merge-subtree"
   "merge-tree" "mergetool" "mktag" "mktree" "mv" "name-rev" "notes" "p4"
   "pack-objects" "pack-redundant" "pack-refs" "patch-id" "prune" "prune-packed"
   "pull" "push" "quiltimport" "read-tree" "rebase" "receive-pack" "reflog"
   "relink" "remote" "remote-ext" "remote-fd" "remote-ftp" "remote-ftps"
   "remote-http" "remote-https" "remote-testsvn" "repack" "replace" "request-pull"
   "rerere" "reset" "rev-list" "rev-parse" "revert" "rm" "send-email" "send-pack"
   "sh-i18n--envsubst" "shell" "shortlog" "show" "show-branch" "show-index"
   "show-ref" "stage" "stash" "status" "stripspace" "submodule" "svn"
   "symbolic-ref" "tag" "unpack-file" "unpack-objects" "update-index" "update-ref"
   "update-server-info" "upload-archive" "upload-pack" "var" "verify-pack"
   "verify-tag" "web--browse" "whatchanged" "write-tree"])

(gen-scm-test-fn "git")

(defn git-help-parse
  "parse the git help output for a list of supported commands"
  []
  (if (git?)
    (->> (nth (->> (with-programs [git] (git "help" "-a" {:seq true}))
                   (partition-by #(= "" %))
                   (filter #(not= (list "") %))) 2)
         (map trim)
         (map #(split % #"  +"))
         (reduce into [])
         (sort))
    (list)))

(gen-base-scm-fn "git")
(defmacro gen-git-fns [] (gen-scm-fns1 "git" git-cmdv))
(gen-git-fns)
