(ns org.ozias.cljlibs.scm.svn
  (:require [clojure.string :refer (split trim)]
            [me.raynes.conch :refer (with-programs)]
            [org.ozias.cljlibs.scm.core :refer :all]))

(def svn-cmdv
  ["?" "add" "ann" "annotate" "blame" "cat" "changelist" "checkout" "ci"
   "cl" "cleanup" "co" "commit" "copy" "cp" "del" "delete" "di" "diff"
   "export" "h" "help" "import" "info" "list" "lock" "log" "ls" "merge"
   "mergeinfo" "mkdir" "move" "mv" "patch" "pd" "pdel" "pe" "pedit" "pg"
   "pget" "pl" "plist" "praise" "propdel" "propedit" "propget" "proplist"
   "propset" "ps" "pset" "relocate" "remove" "ren" "rename" "resolve"
   "resolved" "revert" "rm" "st" "stat" "status" "sw" "switch" "unlock" 
   "up" "update" "upgrade"])

(gen-scm-test-fn "svn")

(defn svn-help-parse
  "parse the svn help output for a list of supported commands"
  []
  (if (svn?)
    (->> (nth (->> (with-programs [svn] (svn "help" {:seq true}))
                   (partition-by #(= "" %))
                   (filter #(not= (list "") %))) 2)
         (rest)
         (map trim)
         (map #(split % #" "))
         (reduce into [])
         (map (fn [mystr] (apply str (filter #(or (Character/isLetter %)(= \? %)) mystr))))
         (sort))
    (list)))

(gen-base-scm-fn "svn")
(defmacro gen-svn-fns [] (gen-scm-fns1 "svn" svn-cmdv))
(gen-svn-fns)
