(ns org.ozias.cljlibs.mvnmeta.protocol.httpx
  (:require [clj-http.client :as client]
            [clojure.data.xml :as xml]
            [org.ozias.cljlibs.mvnmeta.mvnmeta :refer :all]))

(defn- checkauth
  "Check authentication"
  [username password passphrase type]
  (if (and username (or password passphrase))
    (if (or (nil? type) (= type :basic))
      {:basic-auth [username (or password passphrase)]}
      {:digest-auth [username (or password passphrase)]})))

(defn- fetch-md
  "Fecth maven metadata"
  [{:keys [url username password passphrase type]}]
  (let [getargs (vector url)
        getargs (if-let [auth (checkauth username password passphrase type)]
                  (conj getargs auth)
                  getargs)]
    (try
      (-> (apply client/get getargs)
          :body
          xml/parse-str
          xml-seq)
      (catch clojure.lang.ExceptionInfo ei ei)
      (catch Exception ex ex))))

(def ^{:doc "memoization of fetch-md"} fetch-metadata (memoize fetch-md))

(defmethod artifact-metadata "http" [mvnmetamap]
  (fetch-artifact-metadata fetch-metadata mvnmetamap))

(defmethod artifact-metadata "https" [mvnmetamap]
  (fetch-artifact-metadata fetch-metadata mvnmetamap))
