# logging
Clojure Logging Utilities

## Status
[![Build Status](https://travis-ci.org/CraZySacX/logging.png)](https://travis-ci.org/CraZySacX/logging)
[![Dependencies Status](http://jarkeeper.com/CraZySacX/logging/status.png)](http://jarkeeper.com/CraZySacX/logging)

### configure-logging
Configure the [timbre](https://github.com/ptaoussanis/timbre "timbre") logging framework.

The argument is a map of the format:

```clojure
{:options 
 {...
  :logfile "/path/to/log" ;fully qualified path to a logfile
  :verbosity 0-3          ;output level: 0 - warn, 1 - info, 2 - debug, 3 - trace
  :no-color true/false    ;color support disabled/enabled
  :stdout true/false      ;log to stdout (false is default)
  :formatter formatterfn  ;formatting function (see timbre for example)
  ...}}
```

All the keys are optional.  The default configuration will log info and above messages 
to stdout. Note that if no logfile is supplied stdout will be true regardless of the map
value.

Evaluates to the passed in options map.  Useful for threading with parse-opts from 
[tools.cli](https://github.com/clojure/tools.cli "tools.cli").

```clojure
(-> args (parse-opts cli-options) configure-logging)
```

### \(level\)c
These methods will pass 'colored' messages to the corresponding timbre level.
Note that if ```:no-colors``` has been set to true, these will have no effect on the text
and normal unmodified output will occur.

#### Examples
```clojure
(require '[org.ozias.cljlibs.logging.logging :as log])

; Create a vector with tags preceding the text you would like to modify.
(log/errorc [:red :bold "An Error has occurred!!"])

; Create a vector of vectors if you wish to tag different parts of the text.
(log/infoc [[:green "Status:"] [:yellow "golden"]])

; Regular uncolored strings work.
(log/debugc "Debug message here")

; You can mix
(log/infoc [[:red :bold "Important"] "News" [:green "Here!"]])
```

See [colorize](https://github.com/ibdknox/colorize/blob/master/src/colorize/core.clj#L5) for a list of supported tags.
