# logging
Clojure Logging Utilities

### configure-logging
Configure the [timbre](https://github.com/ptaoussanis/timbre "timbre") logging framework.

The argument is a map of the format:

```clojure
{:options 
 {...
  :logfile "/path/to/log" ;fully qualified path to a logfile
  :verbosity 0-3          ;output level: 0 - warn, 1 - info, 2 - debug, 3 - trace
  :stdout true/false      ;log to stdout (false is default)
  :formatter formatterfn  ;formatting function (see timbre for example)
  ...}}
```

All the keys are optional.  The default configuration will log info and above messages 
to stdout. Note that if no logfile is supplied stdout will be true regardless of the map
value.

Evaluates to the passed in options map.  Useful for chaining with parse-opts from 
[tools.cli](https://github.com/clojure/tools.cli "tools.cli").

```clojure
(-> args (parse-opts cli-options) configure-logging)
```
