(defproject org.ozias.cljlibs/logging "0.1.0-SNAPSHOT"
  :description "Clojure Logging Utilities"
  :url "https://github.com/CraZySacX/logging"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[com.taoensso/timbre "3.0.0-RC4"]
                 [org.clojure/clojure "1.5.1"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.6"]
                             [org.clojars.cvillecsteele/lein-git-version "1.0.0"]]}}
  :middleware [lein-git-version.plugin/middleware]
  :aliases {"package" ["do" "clean," "install"]
            "most" ["do" "clean," "doc," "package"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "most," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
         :url "https://github.com/CraZySacX/logging"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.logging.version]
          :sources ["src" "test"]
          :src-dir-uri "http://github.com/CraZySacX/logging/blob/master/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.0-SNAPSHOT"}
  :git-version {:version-command ["git" "rev-parse" "--short" "HEAD"]
                :assoc-keys [[:version] [:manifest "Implementation-Version"]]})
