(defproject org.ozias.cljlibs/logging "0.1.5"
  :description "Clojure Logging Utilities"
  :url "https://github.com/CraZySacX/logging"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[colorize "0.1.1" :exclusions [org.clojure/clojure]]
                 [com.taoensso/timbre "3.1.6"]
                 [environ "0.5.0"]
                 [org.clojure/clojure "1.6.0"]
                 [org.ozias.cljlibs/utils "0.1.7"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojars.jozias/midje "1.6.3"
                                   :exclusions [org.clojure/clojure]]
                                  [org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.8"]
                             [lein-midje "3.1.3"]
                             [org.ozias.plugins/lein-git-version "1.1.3"]]
                   :aliases {"package" ["do" "clean," "install"]
                             "slamhound" ["run" "-m" "slam.hound"]
                             "chk" ["do"
                                    "archaic" "upgrade,"
                                    "slamhound" "src/,"
                                    "slamhound" "test/,"
                                    "eastwood" "{:namespaces [:source-paths]},"
                                    "kibit,"
                                    "bikeshed" "-v,"
                                    "check,"
                                    "midje"]
                             "most" ["do" "clean," "doc," "chk," "package"]
                             "dep" ["do" "deploy," "deploy" "clojars"]
                             "all" ["do" "most," "dep"]}}}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url 
                          "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url 
                          "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
        :url "https://github.com/CraZySacX/logging"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.logging.version]
          :src-dir-uri "http://github.com/CraZySacX/logging/blob/0.1.5/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.5"}
  :git-version {:file {:assoc-in-keys [[:manifest "Implementation-Version"]]}})
