(defproject org.ozias.cljlibs/logging "0.1.1-SNAPSHOT"
  :description "Clojure Logging Utilities"
  :url "https://github.com/CraZySacX/logging"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[colorize "0.1.1" :exclusions [org.clojure/clojure]]
                 [com.taoensso/timbre "3.0.0"]
                 [org.clojure/clojure "1.5.1"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[midje "1.6.0" :exclusions [org.clojure/clojure]]
                                  [org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.6"]
                             [lein-midje "3.1.3"]
                             [org.ozias.plugins/lein-git-version "1.1.0"]]}}
  :aliases {"package" ["do" "clean," "install"]
            "most" ["do" "clean," "doc," "package"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "most," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
        :url "https://github.com/CraZySacX/logging"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.logging.version]
          :sources ["src" "test"]
          :src-dir-uri "http://github.com/CraZySacX/logging/blob/master/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.1-SNAPSHOT"}
  :git-version {:file {:assoc-in-keys [[:manifest "Implementation-Version"]]}})
