(defproject org.ozias.cljlibs/bootstrap "0.1.0-SNAPSHOT"
  :description "Clojure Repl-y Bootstrapper"
  :url "https://github.com/CraZySacX/bootstrap"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[com.taoensso/timbre "3.0.0-RC4"]
                 [org.clojure/clojure "1.5.1"]
                 [org.clojure/tools.cli "0.3.1"]
                 [org.clojure/tools.nrepl "0.2.3"]
                 [org.ozias.cljlibs/shell "0c54a57"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.namespace "0.2.4"]]
                   :plugins [[codox "0.6.6"]
                             [org.ozias.plugins/lein-git-version "1.0.2"]]}}
  :aliases {"package" ["do" "clean," "install"]
            "most" ["do" "clean," "doc," "package"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "most," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :scm {:name "git"
         :url "https://github.com/CraZySacX/bootstrap"}
  :codox {:output-dir "api"
          :exclude [org.ozias.cljlibs.bootstrap.version]
          :sources ["src" "test"]
          :src-dir-uri "http://github.com/CraZySacX/bootstrap/blob/master/"
          :src-linenum-anchor-prefix "L"}
  :manifest {"Implementation-Version" "0.1.0-SNAPSHOT"}
  :git-version {:version-command ["git" "rev-parse" "--short" "HEAD"]
                :version-file-command ["git" "rev-parse" "HEAD"]
                :assoc-in-keys [[:version] [:manifest "Implementation-Version"]]})
