/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.client.ontesting;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Scanner;
import org.orangeplayer.client.net.Connector;
import org.orangeplayer.common.response.Song;

public class TestConnection {
    public static void main(String[] args) {
        try {
            Connector connector = new Connector();
            connector.connect();
            Scanner scanner = new Scanner(System.in);
            if (connector.isConnected()) {
                System.out.println("Connected to servizio");
                boolean playerStarted = connector.isPlayerStarted();
                System.out.println("PlayerStarted: " + playerStarted);
                if (playerStarted) {
                    TestConnection.loadCurrentInfo(connector);
                }
                while (true) {
                    try {
                        while (true) {
                            String line = scanner.nextLine().trim();
                            char c = line.charAt(0);
                            switch (c) {
                                case 'n': {
                                    connector.next();
                                    TestConnection.loadCurrentInfo(connector.getCurrentInfo());
                                    break;
                                }
                                case 'p': {
                                    connector.prev();
                                    TestConnection.loadCurrentInfo(connector.getCurrentInfo());
                                    break;
                                }
                                case 's': {
                                    System.out.println(connector.stop());
                                    break;
                                }
                                case 'r': {
                                    System.out.println(connector.resume());
                                    break;
                                }
                                case 'm': {
                                    System.out.println(connector.pause());
                                    break;
                                }
                                case 'v': {
                                    System.out.println(connector.setGain(Float.parseFloat(line.split(" ")[1])));
                                    break;
                                }
                                case 'k': {
                                    if (line.split(" ").length > 1) {
                                        connector.seekFld(Integer.parseInt(line.split(" ")[1]), Integer.parseInt(line.split(" ")[2]) == 1);
                                        TestConnection.loadCurrentInfo(connector.getCurrentInfo());
                                        break;
                                    }
                                    System.out.println(connector.seek(Integer.parseInt(line.split(" ")[1])));
                                    break;
                                }
                                case 'c': {
                                    TestConnection.loadCurrentInfo(connector.getCurrentInfo());
                                    break;
                                }
                                case 'h': {
                                    System.out.println(connector.shutdown());
                                    break;
                                }
                                case 't': {
                                    System.out.println(playerStarted);
                                    break;
                                }
                                case 'e': {
                                    if (connector.isPlayerStarted()) break;
                                    connector.startPlayer();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Exception: " + e.toString());
                        continue;
                    }
                    break;
                }
            }
            System.out.println("Server is not running");
        }
        catch (IOException e) {
            System.err.println("Server not available");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadCurrentInfo(Song currentInfo) throws IOException {
        if (currentInfo.hasCover()) {
            File coverFile = new File("/home/martin/Testings/cover.png");
            coverFile.createNewFile();
            Files.write(coverFile.toPath(), currentInfo.getCoverData(), StandardOpenOption.TRUNCATE_EXISTING);
            System.out.println("File has cover");
            currentInfo.setCoverData(new byte[0]);
        } else {
            System.out.println("File haven't cover");
        }
        System.out.println(currentInfo);
    }

    private static void loadCurrentInfo(Connector connector) throws IOException, ClassNotFoundException {
        System.out.println("Loading current info.....");
        TestConnection.loadCurrentInfo(connector.getCurrentInfo());
    }
}

