/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.client.net;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.orangeplayer.client.net.OrangeConnector;
import org.orangeplayer.client.net.ServerConnection;
import org.orangeplayer.common.response.PlayerResponse;
import org.orangeplayer.common.response.Song;

public class Connector
implements OrangeConnector {
    private ServerConnection connection;
    private Gson gson;

    public Connector() {
        this("localhost");
    }

    public Connector(String host) {
        this(host, 40000);
    }

    public Connector(String host, int port) {
        this.connection = new ServerConnection(host, port);
        this.gson = new Gson();
    }

    private String getResponse(String urlPath) throws IOException {
        return this.connection.getUrlContent(urlPath);
    }

    private byte[] getResponseAsByteArray(String urlPath) throws IOException {
        return this.connection.getUrlData(urlPath);
    }

    private <T> PlayerResponse<T> deserializeResponse(String urlPath) throws IOException {
        return (PlayerResponse)this.gson.fromJson(this.getResponse(urlPath), PlayerResponse.class);
    }

    private JsonElement deserializeAsJsonElement(String urlPath) throws IOException {
        return new JsonParser().parse(this.getResponse(urlPath));
    }

    private Song deserializeCurrentSong(String urlPath) throws IOException {
        JsonObject jsonObject = this.deserializeAsJsonElement(urlPath).getAsJsonObject();
        Type desearializeType = new TypeToken<Song>(){}.getType();
        return (Song)this.gson.fromJson(jsonObject.get("response"), desearializeType);
    }

    private ArrayList<Song> deserializeListSongs(String urlPath) throws IOException {
        Type type = new TypeToken<ArrayList<Song>>(){}.getType();
        return (ArrayList)this.gson.fromJson(this.getResponse(urlPath), type);
    }

    public Gson getGson() {
        return this.gson;
    }

    public boolean closeConnection() throws IOException {
        return Boolean.valueOf(this.getResponse("/net/unlink"));
    }

    @Override
    public boolean isConnected() throws IOException {
        return Boolean.valueOf(this.getResponse("/net/islinked"));
    }

    @Override
    public boolean isPlayerStarted() throws Exception {
        return Boolean.valueOf(this.getResponse("/player/music/isstarted"));
    }

    @Override
    public boolean connect() throws IOException {
        return Boolean.valueOf(this.getResponse("/net/link"));
    }

    @Override
    public PlayerResponse startPlayer() throws IOException {
        return this.deserializeResponse("/player/music/start");
    }

    @Override
    public PlayerResponse play(String path) throws IOException {
        return this.deserializeResponse("/player/music/play/" + path);
    }

    @Override
    public PlayerResponse stop() throws IOException {
        return this.deserializeResponse("/player/music/stop");
    }

    @Override
    public PlayerResponse resume() throws IOException {
        return this.deserializeResponse("/player/music/resume");
    }

    @Override
    public PlayerResponse pause() throws IOException {
        return this.deserializeResponse("/player/music/pause");
    }

    @Override
    public PlayerResponse next() throws IOException {
        return this.deserializeResponse("/player/music/next");
    }

    @Override
    public PlayerResponse prev() throws IOException {
        return this.deserializeResponse("/player/music/prev");
    }

    @Override
    public PlayerResponse mute() throws IOException {
        return this.deserializeResponse("/player/music/mute");
    }

    @Override
    public PlayerResponse unmute() throws IOException {
        return this.deserializeResponse("/player/music/unmute");
    }

    @Override
    public float getGain() throws IOException {
        return Float.parseFloat(this.getResponse("/player/music/getgain"));
    }

    @Override
    public PlayerResponse setGain(float volume) throws IOException {
        return this.deserializeResponse("/player/music/setgain/" + (int)volume);
    }

    @Override
    public PlayerResponse shutdown() throws IOException {
        return this.deserializeResponse("/player/music/shutdown");
    }

    @Override
    public PlayerResponse seek(int secs) throws IOException {
        return this.deserializeResponse("/player/music/seek/" + secs);
    }

    @Override
    public PlayerResponse seekFld(int jumps, boolean isNext) throws IOException {
        return this.deserializeResponse("/player/music/seekFld/" + jumps + '/' + isNext);
    }

    @Override
    public PlayerResponse gotoSecond(int sec) throws IOException {
        return this.deserializeResponse("/player/music/goto/" + sec);
    }

    @Override
    public byte[] getCoverFromCurrent() throws IOException {
        return this.getResponseAsByteArray("/player/music/currentcover");
    }

    @Override
    public byte[] getCover(String path) throws IOException, ClassNotFoundException {
        return this.getResponseAsByteArray("/player/music/cover/" + path);
    }

    @Override
    public Song getCurrentInfo() throws IOException, ClassNotFoundException {
        Song song = this.deserializeCurrentSong("/player/music/current");
        return song;
    }

    @Override
    public ArrayList<Song> getListSongs() throws IOException {
        return this.deserializeListSongs("/player/music/list");
    }

    @Override
    public String getProgress() throws IOException {
        return this.getResponse("/player/music/progress");
    }

    @Override
    public boolean disconnect() throws IOException {
        return Boolean.valueOf(this.getResponse("/net/unlink"));
    }
}

