/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.TrackIO;

public class TrackUtil {
    public static String getSongInfo(Track track) {
        int i;
        StringBuilder sbInfo = new StringBuilder();
        String title = track.getTitle();
        String album = track.getAlbum();
        String artist = track.getArtist();
        String date = track.getDate();
        String duration = track.getFormattedDuration();
        String hasCover = track.hasCover() ? "Yes" : "No";
        String encoder = track.getEncoder();
        String bitrate = track.getBitrate();
        StringBuilder sbTabs = new StringBuilder();
        String currentLine = "Song: " + title;
        int biggerLength = currentLine.length();
        sbInfo.append(currentLine).append('\n');
        if (album != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Album: " + album;
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (artist != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Artist: " + artist;
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (date != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Date: " + date;
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (duration != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Duration: " + duration;
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        sbTabs.append("    ");
        currentLine = sbTabs.toString() + "Has Cover: " + hasCover;
        if (biggerLength < currentLine.length()) {
            biggerLength = currentLine.length();
        }
        sbInfo.append(currentLine).append('\n');
        if (encoder != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Encoder: " + encoder;
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (bitrate != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Bitrate: " + bitrate + " kbps";
            if (biggerLength < currentLine.length()) {
                biggerLength = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        sbTabs.delete(0, sbTabs.length());
        for (i = 0; i < biggerLength; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n').append(sbInfo.toString());
        for (i = 0; i < biggerLength; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n');
        return sbTabs.toString();
    }

    public static Constructor<? extends Track> getTrackClassConstructor(String formatClass, Class<?> ... paramsClasses) {
        try {
            Class<?> trackClass = Class.forName(formatClass);
            return trackClass.getConstructor(paramsClasses);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Track getTrackFromClass(String formatClass, File dataSource, Player player) {
        try {
            Constructor<? extends Track> constructor = TrackUtil.getTrackClassConstructor(formatClass, dataSource.getClass(), Player.class);
            return constructor != null ? constructor.newInstance(dataSource, player) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Track getTrackFromClass(String formatClass, InputStream dataSource, Player player) {
        try {
            Constructor<? extends Track> constructor = TrackUtil.getTrackClassConstructor(formatClass, dataSource.getClass(), Player.class);
            return constructor != null ? constructor.newInstance(dataSource, player) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getLineInfo(Track track) {
        TrackIO trackIO = track.getTrackIO();
        SourceDataLine driver = trackIO.getSpeaker().getDriver();
        return "Soporte de controles en line" + "---------------" + "Pan: " + driver.isControlSupported(FloatControl.Type.PAN) + "AuxReturn: " + driver.isControlSupported(FloatControl.Type.AUX_RETURN) + "AuxSend: " + driver.isControlSupported(FloatControl.Type.AUX_SEND) + "Balance: " + driver.isControlSupported(FloatControl.Type.BALANCE) + "ReverbReturn: " + driver.isControlSupported(FloatControl.Type.REVERB_RETURN) + "ReberbSend: " + driver.isControlSupported(FloatControl.Type.REVERB_SEND) + "Volume: " + driver.isControlSupported(FloatControl.Type.VOLUME) + "SampleRate: " + driver.isControlSupported(FloatControl.Type.SAMPLE_RATE) + "MasterGain: " + driver.isControlSupported(FloatControl.Type.MASTER_GAIN);
    }
}

