/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.thread;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class TracksLoader {
    private final List<CompletableFuture<?>> listLoadTasks = Collections.synchronizedList(new LinkedList());
    private static final TracksLoader instance = new TracksLoader();

    private TracksLoader() {
    }

    public boolean hasPendingTasks() {
        return this.listLoadTasks.parallelStream().anyMatch(task -> !task.isDone());
    }

    public void deleteFirstCompletedTask() {
        if (!this.listLoadTasks.isEmpty()) {
            this.listLoadTasks.removeIf(CompletableFuture::isDone);
        }
    }

    public CompletableFuture<Void> addTask(Runnable task) {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(task);
        this.listLoadTasks.add(completableFuture);
        return completableFuture;
    }

    public <T> CompletableFuture<T> addTask(Supplier<T> task) {
        CompletableFuture<T> tCompletableFuture = CompletableFuture.supplyAsync(task);
        this.listLoadTasks.add(tCompletableFuture);
        return tCompletableFuture;
    }

    public void removeTask(CompletableFuture<?> task) {
        this.listLoadTasks.remove(task);
    }

    public static TracksLoader getInstance() {
        return instance;
    }
}

