/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.muplayer.properties.log.LogConfig;

public class TimeTester {
    private static final Logger log = Logger.getLogger(TimeTester.class.getName());
    private volatile double startTimestamp;
    private volatile double finishTimestamp;
    private final TimeUnit timeUnit;

    public TimeTester(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    private double getCurrentTime() {
        double currentTime = System.nanoTime();
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return currentTime;
            }
            case MICROSECONDS: {
                return currentTime / Math.pow(1000.0, 1.0);
            }
            case MILLISECONDS: {
                return currentTime / Math.pow(1000.0, 2.0);
            }
            case SECONDS: {
                return currentTime / Math.pow(1000.0, 3.0);
            }
        }
        return 0.0;
    }

    public void start() {
        this.startTimestamp = this.getCurrentTime();
    }

    public void finish() {
        this.finishTimestamp = this.getCurrentTime();
    }

    public String getTimeDifference() {
        double timeDiff = this.finishTimestamp - this.startTimestamp;
        DecimalFormat numberFormat = new DecimalFormat("#0.000");
        return numberFormat.format(timeDiff) + " " + this.timeUnit.name();
    }

    public void logTimeDifference(String msg) {
        LogConfig logConfig = LogConfig.getInstance();
        String logLevel = logConfig.getProperty("logging.level");
        if (!logLevel.equals(Level.OFF.getName())) {
            log.info(msg + ": " + this.getTimeDifference());
        }
    }

    public static void measureTaskTime(TimeUnit timeUnit, String msg, Runnable task) {
        TimeTester timeTester = new TimeTester(timeUnit);
        timeTester.start();
        task.run();
        timeTester.finish();
        timeTester.logTimeDifference(msg);
    }
}

