/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.player.Player;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.runner.ConsoleRunner;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.muplayer.system.SysInfo;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class LocalRunner
extends ConsoleRunner {
    protected final Scanner scanner = new Scanner(System.in);

    public LocalRunner() throws FileNotFoundException {
        this((File)null);
    }

    public LocalRunner(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    public LocalRunner(File rootFolder) throws FileNotFoundException {
        this(new MusicPlayer(rootFolder));
    }

    public LocalRunner(Player player) {
        super(player);
    }

    @Override
    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger((Object)this, (Object)"[MuPlayer]> ").getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger((Object)this, (String)e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    @Override
    public ConsoleExecution execCommand(String strCmd) {
        try {
            return this.interpreter.executeCommand(strCmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void shutdown() {
        this.interpreter.setOn(false);
    }

    @Override
    public void run() {
        String appVersion = SysInfo.readVersion();
        Object msg = appVersion != null ? "MuPlayer v" + appVersion + " started..." : "MuPlayer started...";
        Logger.getLogger((Object)this, (Object)msg).rawInfo();
        this.interpreter.setOn(true);
        while (this.interpreter.isOn()) {
            ConsoleExecution consoleExecution;
            this.printHeader();
            String cmd = this.scanner.nextLine().trim();
            if (cmd.isEmpty() || !(consoleExecution = this.execCommand(cmd)).hasOutput()) continue;
            System.out.println(consoleExecution.getOutputMsg());
        }
        ConsoleRunner runner = (ConsoleRunner)Global.getInstance().getVar(GlobalVar.RUNNER);
        if (runner == null || runner instanceof LocalRunner) {
            System.exit(0);
        }
    }
}

