/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track.states;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.states.TrackState;
import org.muplayer.thread.TPlayingTrack;
import org.muplayer.thread.TaskRunner;
import org.muplayer.thread.ThreadUtil;

public class PlayingState
extends TrackState {
    private static final Logger log = Logger.getLogger(PlayingState.class.getName());
    private final byte[] audioBuffer = new byte[4096];
    private final TPlayingTrack trackThread;
    private static final short BUFF_SIZE = 4096;
    private static final int EOF = -1;

    public PlayingState(Player player, Track track) {
        super(player, track);
        this.trackThread = new TPlayingTrack(track);
    }

    private boolean canPlay() throws IOException {
        return this.trackIO.getSpeaker() != null && this.readNextBytes() != -1;
    }

    private int readNextBytes() throws IOException {
        return this.trackIO.getDecodedStream().read(this.audioBuffer);
    }

    @Override
    public void handle() {
        try {
            String trackThreadName = ThreadUtil.generateTrackThreadName(this.trackThread.getClass(), this.track);
            TaskRunner.execute(this.trackThread, trackThreadName);
            while (this.track.isPlaying()) {
                if (this.canPlay()) {
                    this.trackIO.playAudio(this.audioBuffer);
                    continue;
                }
                if (this.player == null) continue;
                this.player.playNext();
            }
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException e) {
            log.log(Level.SEVERE, "Error on playing sound " + this.track.getTitle() + ": ", e);
            this.player.playNext();
        }
    }
}

