/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.tag.FieldKey;
import org.muplayer.audio.info.AudioHardware;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.TrackData;
import org.muplayer.audio.track.TrackIO;
import org.muplayer.audio.track.states.InitializedState;
import org.muplayer.audio.track.states.KilledState;
import org.muplayer.audio.track.states.PausedState;
import org.muplayer.audio.track.states.PlayingState;
import org.muplayer.audio.track.states.ReverberatedState;
import org.muplayer.audio.track.states.StartedState;
import org.muplayer.audio.track.states.StoppedState;
import org.muplayer.audio.track.states.TrackState;
import org.muplayer.interfaces.ControllableMusic;
import org.muplayer.interfaces.ReportableTrack;
import org.muplayer.properties.support.AudioSupportInfo;
import org.muplayer.util.AudioUtil;
import org.muplayer.util.FileUtil;
import org.muplayer.util.TrackUtil;

public abstract class Track
extends Thread
implements ControllableMusic,
ReportableTrack {
    private static final Logger log = Logger.getLogger(Track.class.getName());
    protected volatile Object dataSource;
    protected volatile AudioTag tagInfo;
    protected volatile TrackIO trackIO;
    protected volatile TrackData trackData;
    protected volatile TrackState trackState;
    protected final Player player;

    public static Track getTrack(Object dataSource) {
        return Track.getTrack(dataSource, null);
    }

    public static Track getTrack(Object dataSource, Player player) {
        if (dataSource instanceof File || dataSource instanceof String) {
            File fileSource;
            File file = fileSource = dataSource instanceof File ? (File)dataSource : new File((String)dataSource);
            if (!fileSource.exists()) {
                return null;
            }
            Track result = null;
            String formatName = FileUtil.getFormatName(fileSource.getName());
            AudioSupportInfo audioSupportInfo = AudioSupportInfo.getInstance();
            String formatClass = audioSupportInfo.getProperty(formatName);
            if (AudioUtil.isSupportedFile(fileSource)) {
                result = TrackUtil.getTrackFromClass(formatClass, fileSource, player);
            }
            return result;
        }
        return null;
    }

    protected Track(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(dataSource, null);
    }

    protected Track(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath), null);
    }

    protected Track(File dataSource, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.dataSource = dataSource;
        this.player = player;
        this.trackState = new InitializedState(player, this);
        this.setPriority(10);
    }

    protected Track(String trackPath, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath), player);
    }

    protected abstract void loadAudioStream() throws IOException, UnsupportedAudioFileException;

    protected abstract double convertSecondsToBytes(Number var1);

    protected abstract double convertBytesToSeconds(Number var1);

    public AudioTag loadTagInfo(File dataSource) {
        try {
            AudioTag audioTag = new AudioTag(dataSource);
            return audioTag.isValidFile() ? audioTag : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void initSpeaker() throws LineUnavailableException {
        if (this.trackIO.initSpeaker()) {
            this.setVolume(this.trackData.getVolume());
        }
    }

    public void initStreamAndLine() throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.loadAudioStream();
        this.initSpeaker();
    }

    public void resetStream() throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        if (this.trackIO.closeStream() && this.trackIO.closeSpeaker()) {
            this.initStreamAndLine();
        }
    }

    public String getStateToString() {
        return this.trackState.getName();
    }

    public File getDataSourceAsFile() {
        return this.dataSource instanceof File ? (File)this.dataSource : null;
    }

    @Override
    public long getDuration() {
        return this.tagInfo != null ? (long)this.tagInfo.getDuration() : 0L;
    }

    @Override
    public synchronized double getProgress() {
        return this.trackIO.getSecondsPosition() + this.trackData.getSecsSeeked();
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.trackState instanceof PlayingState;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.trackState instanceof PausedState;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.trackState instanceof StoppedState;
    }

    public synchronized boolean isKilled() {
        return this.trackState instanceof KilledState;
    }

    @Override
    public boolean isMute() {
        return this.trackData.isMute();
    }

    @Override
    public void play() {
        if (this.isAlive()) {
            this.trackState = new PlayingState(this.player, this);
        }
    }

    @Override
    public void pause() {
        if (this.isPlaying()) {
            this.trackState = new PausedState(this.player, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeTrack() {
        if (this.isAlive() && (this.isPaused() || this.isStopped())) {
            this.play();
            Track track = this;
            synchronized (track) {
                this.notify();
            }
        }
    }

    @Override
    public synchronized void stopTrack() {
        if (this.isAlive() && (this.isPlaying() || this.isPaused())) {
            this.trackState = new StoppedState(this.player, this);
        }
    }

    @Override
    public void reload() throws Exception {
    }

    public void kill() {
        this.trackState = new KilledState(this.player, this);
    }

    @Override
    public synchronized void seek(double seconds) throws IOException {
        if (seconds > 0.0) {
            long bytesToSeek = Math.round(this.convertSecondsToBytes(seconds));
            long skip = this.trackIO.getDecodedStream().skip(bytesToSeek);
            double skippedSeconds = this.convertBytesToSeconds(skip);
            if (skip > 0L) {
                this.trackData.setSecsSeeked(this.trackData.getSecsSeeked() + skippedSeconds);
            }
        } else if (seconds < 0.0) {
            try {
                this.gotoSecond(this.getProgress() + seconds);
            }
            catch (LineUnavailableException | UnsupportedAudioFileException e) {
                log.severe(e.getMessage());
            }
        }
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int duration = (int)this.getDuration();
            if (second > (double)duration) {
                second = duration;
            }
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else {
            this.trackState = new ReverberatedState(this.player, this, second);
        }
    }

    @Override
    public float getVolume() {
        return this.trackData.isMute() ? 0.0f : this.trackData.getVolume();
    }

    @Override
    public void setVolume(float volume) {
        this.trackData.setVolume(volume);
        if (this.trackIO != null && this.trackIO.isTrackStreamsOpened()) {
            this.trackIO.setGain(AudioUtil.convertVolRangeToLineRange(volume));
            if (this.trackData.isVolumeZero()) {
                AudioHardware.setMuteValue(this.trackIO.getSpeakerDriver(), true);
            }
        }
    }

    @Override
    public void mute() {
        this.trackData.setMute(true);
        if (this.trackIO != null && this.trackIO.isTrackStreamsOpened()) {
            AudioHardware.setMuteValue(this.trackIO.getSpeakerDriver(), this.trackData.isMute());
        }
    }

    @Override
    public void unMute() {
        if (this.trackData.isVolumeZero()) {
            this.trackData.setVolume(100.0f);
            if (this.trackIO != null && this.trackIO.isTrackStreamsOpened()) {
                this.trackIO.setGain(AudioUtil.convertVolRangeToLineRange(this.trackData.getVolume()));
            }
        } else {
            this.trackData.setMute(false);
        }
        if (this.trackIO != null && this.trackIO.isTrackStreamsOpened()) {
            AudioHardware.setMuteValue(this.trackIO.getSpeakerDriver(), false);
        }
    }

    @Override
    public boolean hasCover() {
        return this.tagInfo != null && this.tagInfo.getCover() != null;
    }

    @Override
    public String getProperty(String key) {
        return this.tagInfo == null ? null : this.tagInfo.getTag(key);
    }

    @Override
    public String getProperty(FieldKey key) {
        return this.tagInfo != null ? this.tagInfo.getTag(key) : null;
    }

    @Override
    public String getTitle() {
        String titleProper = this.getProperty(FieldKey.TITLE);
        File fileSource = this.dataSource != null && this.dataSource instanceof File ? (File)this.dataSource : null;
        return (titleProper == null || titleProper.trim().isEmpty()) && fileSource != null ? fileSource.getName() : titleProper;
    }

    @Override
    public String getAlbum() {
        return this.getProperty(FieldKey.ALBUM);
    }

    @Override
    public String getArtist() {
        return this.getProperty(FieldKey.ARTIST);
    }

    @Override
    public String getDate() {
        return this.getProperty(FieldKey.YEAR);
    }

    @Override
    public byte[] getCoverData() {
        return this.tagInfo != null ? this.tagInfo.getCoverData() : null;
    }

    @Override
    public String getEncoder() {
        return this.getProperty(FieldKey.ENCODER);
    }

    @Override
    public String getBitrate() {
        return this.tagInfo != null && this.tagInfo.getHeader() != null ? this.tagInfo.getHeader().getBitRate() : "Unknown";
    }

    @Override
    public String getFormat() {
        return this.trackIO.getDecodedStream().getFormat().toString();
    }

    @Override
    public synchronized void start() {
        if (this.getState() == Thread.State.NEW) {
            super.start();
        } else {
            this.trackState = new StartedState(this.player, this);
        }
    }

    @Override
    public void run() {
        this.trackState = new StartedState(this.player, this);
        while (this.trackData.canTrackContinue()) {
            this.trackState.handle();
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public AudioTag getTagInfo() {
        return this.tagInfo;
    }

    public TrackIO getTrackIO() {
        return this.trackIO;
    }

    public TrackData getTrackData() {
        return this.trackData;
    }

    public TrackState getTrackState() {
        return this.trackState;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setDataSource(Object dataSource) {
        this.dataSource = dataSource;
    }

    public void setTagInfo(AudioTag tagInfo) {
        this.tagInfo = tagInfo;
    }

    public void setTrackIO(TrackIO trackIO) {
        this.trackIO = trackIO;
    }

    public void setTrackData(TrackData trackData) {
        this.trackData = trackData;
    }

    public void setTrackState(TrackState trackState) {
        this.trackState = trackState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Track)) {
            return false;
        }
        Track other = (Track)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$dataSource = this.getDataSource();
        Object other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        AudioTag this$tagInfo = this.getTagInfo();
        AudioTag other$tagInfo = other.getTagInfo();
        if (this$tagInfo == null ? other$tagInfo != null : !((Object)this$tagInfo).equals(other$tagInfo)) {
            return false;
        }
        TrackIO this$trackIO = this.getTrackIO();
        TrackIO other$trackIO = other.getTrackIO();
        if (this$trackIO == null ? other$trackIO != null : !((Object)this$trackIO).equals(other$trackIO)) {
            return false;
        }
        TrackData this$trackData = this.getTrackData();
        TrackData other$trackData = other.getTrackData();
        if (this$trackData == null ? other$trackData != null : !((Object)this$trackData).equals(other$trackData)) {
            return false;
        }
        TrackState this$trackState = this.getTrackState();
        TrackState other$trackState = other.getTrackState();
        if (this$trackState == null ? other$trackState != null : !((Object)this$trackState).equals(other$trackState)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        return !(this$player == null ? other$player != null : !this$player.equals(other$player));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Track;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        AudioTag $tagInfo = this.getTagInfo();
        result = result * 59 + ($tagInfo == null ? 43 : ((Object)$tagInfo).hashCode());
        TrackIO $trackIO = this.getTrackIO();
        result = result * 59 + ($trackIO == null ? 43 : ((Object)$trackIO).hashCode());
        TrackData $trackData = this.getTrackData();
        result = result * 59 + ($trackData == null ? 43 : ((Object)$trackData).hashCode());
        TrackState $trackState = this.getTrackState();
        result = result * 59 + ($trackState == null ? 43 : ((Object)$trackState).hashCode());
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Track(dataSource=" + this.getDataSource() + ", tagInfo=" + this.getTagInfo() + ", trackIO=" + this.getTrackIO() + ", trackData=" + this.getTrackData() + ", trackState=" + this.getTrackState() + ", player=" + this.getPlayer() + ")";
    }
}

