/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.player;

import org.muplayer.util.AudioUtil;

public class PlayerData {
    private volatile int trackIndex = -1;
    private volatile float volume = DEFAULT_VOLUME;
    private volatile boolean on = false;
    private volatile boolean isMute = false;
    public static final float DEFAULT_VOLUME = AudioUtil.convertLineRangeToVolRange(40.4275f);

    public synchronized boolean isVolumeZero() {
        return this.volume == 0.0f;
    }

    public synchronized void setVolume(float volume) {
        this.volume = volume > 100.0f ? 100.0f : (volume < 0.0f ? 0.0f : volume);
        this.isMute = this.isVolumeZero();
    }

    public synchronized void increaseTrackIndex(int steps) {
        this.trackIndex += steps;
    }

    public synchronized void decreaseTrackIndex(int steps) {
        this.trackIndex -= steps;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void setTrackIndex(int trackIndex) {
        this.trackIndex = trackIndex;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerData)) {
            return false;
        }
        PlayerData other = (PlayerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTrackIndex() != other.getTrackIndex()) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (this.isOn() != other.isOn()) {
            return false;
        }
        return this.isMute() == other.isMute();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTrackIndex();
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + (this.isOn() ? 79 : 97);
        result = result * 59 + (this.isMute() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PlayerData(trackIndex=" + this.getTrackIndex() + ", volume=" + this.getVolume() + ", on=" + this.isOn() + ", isMute=" + this.isMute() + ")";
    }
}

