/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.thread;

import java.io.File;
import java.io.IOException;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.track.Track;

public class TPlayingTrack
implements Runnable {
    private final Track track;
    private final MusicPlayer trackPlayer;

    public TPlayingTrack(Track track) {
        this.track = track;
        this.trackPlayer = track.getPlayer() instanceof MusicPlayer ? (MusicPlayer)track.getPlayer() : null;
    }

    public boolean hasTrack(Track track) {
        try {
            File dataSource = this.track.getDataSourceAsFile();
            String dataSourcePath = dataSource.getCanonicalPath();
            String anotherSourcePath = dataSource.getCanonicalPath();
            return dataSourcePath.equals(anotherSourcePath);
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public void run() {
        if (this.trackPlayer != null) {
            while (this.track.isPlaying()) {
                try {
                    this.trackPlayer.loadListenerMethod("onPlaying", this.track);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

