/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track.states;

import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.TrackData;
import org.muplayer.audio.track.TrackIO;

public abstract class TrackState {
    protected final Player player;
    protected final Track track;
    protected volatile TrackData trackData;
    protected volatile TrackIO trackIO;

    public TrackState(Player player, Track track) {
        this.player = player;
        this.track = track;
        this.trackData = track.getTrackData();
        this.trackIO = track.getTrackIO();
    }

    public String getName() {
        String className = this.getClass().getSimpleName();
        return className.replace("State", "").trim();
    }

    public abstract void handle();

    public Player getPlayer() {
        return this.player;
    }

    public Track getTrack() {
        return this.track;
    }

    public TrackData getTrackData() {
        return this.trackData;
    }

    public TrackIO getTrackIO() {
        return this.trackIO;
    }

    public void setTrackData(TrackData trackData) {
        this.trackData = trackData;
    }

    public void setTrackIO(TrackIO trackIO) {
        this.trackIO = trackIO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackState)) {
            return false;
        }
        TrackState other = (TrackState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Track this$track = this.getTrack();
        Track other$track = other.getTrack();
        if (this$track == null ? other$track != null : !((Object)this$track).equals(other$track)) {
            return false;
        }
        TrackData this$trackData = this.getTrackData();
        TrackData other$trackData = other.getTrackData();
        if (this$trackData == null ? other$trackData != null : !((Object)this$trackData).equals(other$trackData)) {
            return false;
        }
        TrackIO this$trackIO = this.getTrackIO();
        TrackIO other$trackIO = other.getTrackIO();
        return !(this$trackIO == null ? other$trackIO != null : !((Object)this$trackIO).equals(other$trackIO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Track $track = this.getTrack();
        result = result * 59 + ($track == null ? 43 : ((Object)$track).hashCode());
        TrackData $trackData = this.getTrackData();
        result = result * 59 + ($trackData == null ? 43 : ((Object)$trackData).hashCode());
        TrackIO $trackIO = this.getTrackIO();
        result = result * 59 + ($trackIO == null ? 43 : ((Object)$trackIO).hashCode());
        return result;
    }

    public String toString() {
        return "TrackState(player=" + this.getPlayer() + ", track=" + this.getTrack() + ", trackData=" + this.getTrackData() + ", trackIO=" + this.getTrackIO() + ")";
    }
}

