/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

public class TrackData {
    private volatile double secsSeeked;
    private volatile double bytesPerSecond;
    private volatile float volume;
    private volatile boolean isMute;
    private volatile boolean canTrackContinue;

    public synchronized boolean isVolumeZero() {
        return this.volume == 0.0f;
    }

    public boolean canTrackContinue() {
        return this.canTrackContinue;
    }

    public synchronized float getVolume() {
        return this.isMute ? 0.0f : this.volume;
    }

    public synchronized void setVolume(float volume) {
        this.volume = volume > 100.0f ? 100.0f : (volume < 0.0f ? 0.0f : volume);
        this.isMute = this.isVolumeZero();
    }

    public static TrackDataBuilder builder() {
        return new TrackDataBuilder();
    }

    public double getSecsSeeked() {
        return this.secsSeeked;
    }

    public double getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void setSecsSeeked(double secsSeeked) {
        this.secsSeeked = secsSeeked;
    }

    public void setBytesPerSecond(double bytesPerSecond) {
        this.bytesPerSecond = bytesPerSecond;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public void setCanTrackContinue(boolean canTrackContinue) {
        this.canTrackContinue = canTrackContinue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackData)) {
            return false;
        }
        TrackData other = (TrackData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSecsSeeked(), other.getSecsSeeked()) != 0) {
            return false;
        }
        if (Double.compare(this.getBytesPerSecond(), other.getBytesPerSecond()) != 0) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (this.isMute() != other.isMute()) {
            return false;
        }
        return this.canTrackContinue == other.canTrackContinue;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $secsSeeked = Double.doubleToLongBits(this.getSecsSeeked());
        result = result * 59 + (int)($secsSeeked >>> 32 ^ $secsSeeked);
        long $bytesPerSecond = Double.doubleToLongBits(this.getBytesPerSecond());
        result = result * 59 + (int)($bytesPerSecond >>> 32 ^ $bytesPerSecond);
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + (this.isMute() ? 79 : 97);
        result = result * 59 + (this.canTrackContinue ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TrackData(secsSeeked=" + this.getSecsSeeked() + ", bytesPerSecond=" + this.getBytesPerSecond() + ", volume=" + this.getVolume() + ", isMute=" + this.isMute() + ", canTrackContinue=" + this.canTrackContinue + ")";
    }

    public TrackData() {
    }

    public TrackData(double secsSeeked, double bytesPerSecond, float volume, boolean isMute, boolean canTrackContinue) {
        this.secsSeeked = secsSeeked;
        this.bytesPerSecond = bytesPerSecond;
        this.volume = volume;
        this.isMute = isMute;
        this.canTrackContinue = canTrackContinue;
    }

    public static class TrackDataBuilder {
        private double secsSeeked;
        private double bytesPerSecond;
        private float volume;
        private boolean isMute;
        private boolean canTrackContinue;

        TrackDataBuilder() {
        }

        public TrackDataBuilder secsSeeked(double secsSeeked) {
            this.secsSeeked = secsSeeked;
            return this;
        }

        public TrackDataBuilder bytesPerSecond(double bytesPerSecond) {
            this.bytesPerSecond = bytesPerSecond;
            return this;
        }

        public TrackDataBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public TrackDataBuilder isMute(boolean isMute) {
            this.isMute = isMute;
            return this;
        }

        public TrackDataBuilder canTrackContinue(boolean canTrackContinue) {
            this.canTrackContinue = canTrackContinue;
            return this;
        }

        public TrackData build() {
            return new TrackData(this.secsSeeked, this.bytesPerSecond, this.volume, this.isMute, this.canTrackContinue);
        }

        public String toString() {
            return "TrackData.TrackDataBuilder(secsSeeked=" + this.secsSeeked + ", bytesPerSecond=" + this.bytesPerSecond + ", volume=" + this.volume + ", isMute=" + this.isMute + ", canTrackContinue=" + this.canTrackContinue + ")";
        }
    }
}

