/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties.support;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.muplayer.model.AudioSupport;
import org.muplayer.properties.FilePropertiesSource;
import org.muplayer.properties.PropertiesFiles;
import org.muplayer.properties.PropertiesInfo;
import org.muplayer.properties.support.ResAudioSupportInfo;

public class AudioSupportInfo
extends PropertiesInfo<File> {
    private static final AudioSupportInfo instance = new AudioSupportInfo();
    public static final String KEY_PREFFIX = "audio.format.class.";
    private static final String DEFAULT_COMMENT = "Audio formats support";

    private AudioSupportInfo() {
        super(new FilePropertiesSource(PropertiesFiles.AUDIO_SUPPORT_FILE_PATH));
    }

    @Override
    public void loadDefaultData() {
        if (this.properties.isEmpty()) {
            ResAudioSupportInfo resAudioSupportInfo = ResAudioSupportInfo.getInstance();
            resAudioSupportInfo.getPropertyNames().forEach(name -> {
                try {
                    this.setProperty((String)name, resAudioSupportInfo.getProperty((String)name));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            try {
                this.propertiesSource.saveData(this.properties, DEFAULT_COMMENT);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.startsWith(KEY_PREFFIX) ? key : KEY_PREFFIX.concat(key));
    }

    public Set<String> getAudioExtensions() {
        return this.getPropertyNames().parallelStream().map(prop -> prop.substring(KEY_PREFFIX.length())).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void setProperty(AudioSupport audioSupport) throws Exception {
        this.setProperty(KEY_PREFFIX.concat(audioSupport.getExtension()), audioSupport.getAudioClass().getName());
    }

    @Override
    public void setProperty(String key, String value) throws Exception {
        super.setProperty(key.startsWith(KEY_PREFFIX) ? key : KEY_PREFFIX.concat(key), value);
    }

    public static AudioSupportInfo getInstance() {
        return instance;
    }
}

