/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.console.Command;
import org.muplayer.console.CommandInterpreter;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.runner.ConsoleRunner;
import org.muplayer.console.runner.DaemonRunner;
import org.muplayer.console.runner.LocalRunner;
import org.muplayer.console.runner.RunnerMode;
import org.muplayer.model.Album;
import org.muplayer.model.Artist;
import org.muplayer.model.SeekOption;
import org.muplayer.properties.help.HelpInfo;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.muplayer.system.SysInfo;
import org.muplayer.thread.TaskRunner;
import org.muplayer.util.TrackUtil;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsoleInterpreter
implements CommandInterpreter {
    private Player player;
    private final File playerFolder;
    private boolean on;
    private final HelpInfo helpInfo;
    private static final String CMD_DIVISOR = " && ";

    public ConsoleInterpreter(Player player) {
        this.player = player;
        this.playerFolder = player.getRootFolder();
        this.helpInfo = HelpInfo.getInstance();
    }

    private boolean isPlayerOn() {
        return this.player != null && this.player.isAlive();
    }

    private void execSysCommand(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            if (process.exitValue() == 0) {
                this.printStreamOut(process.getInputStream());
            } else {
                this.printStreamOut(process.getErrorStream());
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getLogger((Object)this, (Object)e.getMessage()).error();
        }
    }

    private void printTracks(ConsoleExecution execution) {
        File rootFolder = this.player.getRootFolder();
        List<Track> listTracks = this.player.getTracks();
        Track current = this.player.getCurrent();
        execution.appendOutput("------------------------------", "info");
        if (rootFolder == null) {
            execution.appendOutput("Music in folder", "info");
        } else {
            execution.appendOutput("Music in folder " + rootFolder.getName(), "info");
        }
        execution.appendOutput("------------------------------", "info");
        if (rootFolder != null) {
            for (int i = 0; i < this.player.getSongsCount(); ++i) {
                Track track = listTracks.get(i);
                File fileTrack = track.getDataSourceAsFile();
                if (current != null && fileTrack.getPath().equals(current.getDataSourceAsFile().getPath())) {
                    execution.appendOutput("Track " + (i + 1) + ": " + fileTrack.getName(), "warn");
                    continue;
                }
                execution.appendOutput("Track " + (i + 1) + ": " + fileTrack.getName(), "info");
            }
            execution.appendOutput("------------------------------", "info");
        }
    }

    private void printDetailedTracks(ConsoleExecution execution) {
        File rootFolder = this.player.getRootFolder();
        List<Track> listTracks = this.player.getTracks();
        Track current = this.player.getCurrent();
        execution.appendOutput("------------------------------", "info");
        if (rootFolder == null) {
            execution.appendOutput("Music in folder", "info");
        } else {
            execution.appendOutput("Music in folder " + rootFolder.getName(), "info");
        }
        execution.appendOutput("------------------------------", "info");
        if (rootFolder != null) {
            File prevTrackFolder = null;
            for (int i = 0; i < this.player.getSongsCount(); ++i) {
                File trackFile = listTracks.get(i).getDataSourceAsFile();
                File trackFolder = trackFile.getParentFile();
                if (prevTrackFolder == null || !trackFolder.getPath().equals(prevTrackFolder.getPath())) {
                    execution.appendOutput((prevTrackFolder != null ? "----------------------------------------------------------------------\n\n----------------------------------------------------------------------\nFolder: " : "----------------------------------------------------------------------\nFolder: ") + trackFolder.getName(), "info");
                }
                if (current != null && trackFile.getPath().equals(current.getDataSourceAsFile().getPath())) {
                    execution.appendOutput("\tTrack " + (i + 1) + ": " + trackFile.getName(), "warn");
                } else {
                    execution.appendOutput("\tTrack " + (i + 1) + ": " + trackFile.getName(), "info");
                }
                prevTrackFolder = trackFile.getParentFile();
            }
            execution.appendOutput("------------------------------", "info");
        }
    }

    private synchronized void printFolderTracks(ConsoleExecution execution) {
        List<Track> listTracks = this.player.getTracks();
        Track current = this.player.getCurrent();
        int songsCount = this.player.getSongsCount();
        File parentFolder = current == null ? null : current.getDataSourceAsFile().getParentFile();
        execution.appendOutput("------------------------------", "info");
        if (parentFolder == null) {
            execution.appendOutput("Music in current folder", "info");
        } else {
            execution.appendOutput("Music in folder " + parentFolder.getName(), "info");
        }
        execution.appendOutput("------------------------------", "info");
        if (parentFolder != null) {
            File currentFile = current.getDataSourceAsFile();
            for (int i = 0; i < songsCount; ++i) {
                File fileTrack = listTracks.get(i).getDataSourceAsFile();
                if (!fileTrack.getParentFile().equals(parentFolder)) continue;
                if (fileTrack.getPath().equals(currentFile.getPath())) {
                    execution.appendOutput("Track " + (i + 1) + ": " + fileTrack.getName(), "warn");
                    continue;
                }
                execution.appendOutput("Track " + (i + 1) + ": " + fileTrack.getName(), "info");
            }
            execution.appendOutput("------------------------------", "info");
        }
    }

    private synchronized void printFolderTracks(ConsoleExecution execution, int index) {
        File folder = this.player.getListFolders().get(index - 1);
        File currentFile = this.player.getCurrent().getDataSourceAsFile();
        execution.appendOutput("------------------------------", "info");
        if (folder != null) {
            execution.appendOutput("Music in folder " + folder.getName(), "info");
            execution.appendOutput("------------------------------", "info");
            AtomicInteger counter = new AtomicInteger(1);
            this.player.getTracks().stream().filter(track -> track.getDataSourceAsFile().getParent().equals(folder.getPath())).forEach(track -> {
                File fileTrack = track.getDataSourceAsFile();
                if (fileTrack.getParentFile().equals(folder)) {
                    if (fileTrack.getPath().equals(currentFile.getPath())) {
                        execution.appendOutput("Track " + counter.getAndIncrement() + ": " + fileTrack.getName(), "warn");
                    } else {
                        execution.appendOutput("Track " + counter.getAndIncrement() + ": " + fileTrack.getName(), "info");
                    }
                }
            });
            execution.appendOutput("------------------------------", "info");
        }
    }

    private synchronized void printFolders(ConsoleExecution execution) {
        File rootFolder = this.player.getRootFolder();
        List listFolderPaths = this.player.getListFolders().stream().map(File::getPath).collect(Collectors.toList());
        Track current = this.player.getCurrent();
        execution.appendOutput("------------------------------", "info");
        if (rootFolder == null) {
            execution.appendOutput("Folders", "info");
        } else {
            execution.appendOutput("Folders in " + rootFolder.getName(), "info");
        }
        execution.appendOutput("------------------------------", "info");
        if (current == null) {
            return;
        }
        File currentTrackFile = current.getDataSourceAsFile();
        for (int i = 0; i < this.player.getFoldersCount(); ++i) {
            File folder = new File((String)listFolderPaths.get(i));
            if (folder.getPath().equals(currentTrackFile.getParentFile().getPath())) {
                execution.appendOutput("Folder " + (i + 1) + ": " + folder.getName(), "warn");
                continue;
            }
            execution.appendOutput("Folder " + (i + 1) + ": " + folder.getName(), "info");
        }
        execution.appendOutput("------------------------------", "info");
    }

    protected void printStreamOut(InputStream cmdStream) throws IOException {
        int read;
        FileOutputStream stdout = SystemUtil.getStdout();
        while ((read = cmdStream.read()) != -1) {
            stdout.write(read);
        }
    }

    protected void clearConsole() throws IOException {
        Process process = SysInfo.IS_UNIX ? Runtime.getRuntime().exec("clear") : Runtime.getRuntime().exec("cls");
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (process.exitValue() == 0) {
            this.printStreamOut(process.getInputStream());
        } else {
            this.printStreamOut(process.getErrorStream());
        }
    }

    protected void printHelp(ConsoleExecution execution) {
        Set<String> propertyNames = this.helpInfo.getPropertyNames();
        Iterator<String> it = propertyNames.iterator();
        StringBuilder sbHelp = new StringBuilder();
        int count = 1;
        while (it.hasNext()) {
            String key = it.next();
            sbHelp.append(count++).append(") ").append(key).append(": ").append(this.helpInfo.getProperty(key)).append('\n');
        }
        execution.appendOutput("---------", "warn");
        execution.appendOutput("Help Info", "warn");
        execution.appendOutput("---------", "warn");
        execution.appendOutput(sbHelp.toString(), "warn");
    }

    public void showSongInfo(Track track, ConsoleExecution execution) {
        if (track == null) {
            execution.appendOutput("Current track unavailable", "error");
        } else {
            execution.appendOutput(TrackUtil.getSongInfo(track), "warn");
        }
    }

    @Override
    public ConsoleExecution executeCommand(String cmd) throws Exception {
        if (cmd.contains(CMD_DIVISOR)) {
            String[] cmdSplit = cmd.split(CMD_DIVISOR);
            ConsoleExecution consoleExecution = new ConsoleExecution();
            ArrayList<String> listExec = new ArrayList<String>();
            for (int i = 0; i < cmdSplit.length; ++i) {
                ConsoleExecution exec = this.executeCommand(cmdSplit[i].trim());
                if (exec == null) continue;
                listExec.add(exec.getOutputMsg());
            }
            consoleExecution.setCmd(cmd);
            consoleExecution.appendOutput(listExec.get(listExec.size() - 1), "");
            return consoleExecution;
        }
        return this.executeCommand(new Command(cmd));
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    @Override
    public ConsoleExecution executeCommand(Command cmd) throws Exception {
        String cmdOrder = cmd.getOrder();
        ConsoleExecution execution = new ConsoleExecution();
        execution.setCmd(cmd.toString());
        switch (cmdOrder) {
            case "st": {
                if (this.player == null) {
                    this.player = new MusicPlayer(this.playerFolder);
                }
                if (this.player.isAlive() && cmd.hasOptions()) {
                    File musicFolder = new File(cmd.getOptionAt(0));
                    if (musicFolder.exists()) {
                        MusicPlayer newMusicPlayer = new MusicPlayer(musicFolder);
                        this.player.shutdown();
                        newMusicPlayer.start();
                        this.player = newMusicPlayer;
                    } else {
                        execution.appendOutput("Folder not exists", "error");
                    }
                } else if (!this.player.isAlive()) {
                    this.player.start();
                }
                if (this.player.getCurrent() == null) break;
                this.showSongInfo(this.player.getCurrent(), execution);
                break;
            }
            case "ist": {
                execution.appendOutput(this.isPlayerOn() ? "Is playing" : "Is not playing", "warn");
                break;
            }
            case "pl": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    Number playIndex = cmd.getOptionAsNumber(0);
                    if (playIndex != null && playIndex.intValue() > 0 && playIndex.intValue() <= this.player.getSongsCount()) {
                        this.player.play(playIndex.intValue() - 1);
                    }
                    this.showSongInfo(this.player.getCurrent(), execution);
                    break;
                }
                this.player.play();
                break;
            }
            case "ps": {
                if (!this.isPlayerOn()) break;
                this.player.pause();
                break;
            }
            case "s": {
                if (!this.isPlayerOn()) break;
                try {
                    this.player.stopTrack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "r": {
                if (!this.isPlayerOn()) break;
                this.player.resumeTrack();
                break;
            }
            case "n": {
                if (this.isPlayerOn()) {
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            execution.appendOutput("Jump value incorrect", "error");
                        } else {
                            this.player.jumpTrack(jumps.intValue(), SeekOption.NEXT);
                        }
                    } else {
                        this.player.playNext();
                    }
                }
                this.showSongInfo(this.player.getCurrent(), execution);
                break;
            }
            case "p": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    Number jumps = cmd.getOptionAsNumber(0);
                    if (jumps == null) {
                        execution.appendOutput("Jump value incorrect", "error");
                    } else {
                        this.player.jumpTrack(jumps.intValue(), SeekOption.PREV);
                    }
                } else {
                    this.player.playPrevious();
                }
                this.showSongInfo(this.player.getCurrent(), execution);
                break;
            }
            case "m": {
                if (!this.isPlayerOn()) break;
                this.player.mute();
                break;
            }
            case "um": {
                if (!this.isPlayerOn()) break;
                this.player.unMute();
                break;
            }
            case "l": 
            case "list": {
                if (this.player == null) break;
                this.printTracks(execution);
                break;
            }
            case "lc": {
                if (!this.isPlayerOn()) break;
                this.printFolderTracks(execution);
                break;
            }
            case "lf": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    try {
                        Number index = cmd.getOptionAsNumber(0);
                        this.printFolderTracks(execution, index.intValue());
                    }
                    catch (NumberFormatException index) {}
                    break;
                }
                this.printFolders(execution);
                break;
            }
            case "ld": {
                if (!this.isPlayerOn()) break;
                this.printDetailedTracks(execution);
                break;
            }
            case "gv": {
                if (this.player == null) break;
                execution.appendOutput("Player Volume(0-100): " + this.player.getVolume(), "warn");
                break;
            }
            case "v": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number volume = cmd.getOptionAsNumber(0);
                if (volume == null) {
                    execution.appendOutput("Volume value incorrect", "error");
                    break;
                }
                this.player.setVolume(volume.floatValue());
                execution.appendOutput("Volume value changed", "warn");
                break;
            }
            case "gsv": {
                if (this.player == null) break;
                execution.appendOutput("Player Volume(0-100): " + this.player.getSystemVolume(), "warn");
                break;
            }
            case "sv": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number volume = cmd.getOptionAsNumber(0);
                if (volume == null) {
                    execution.appendOutput("Volume value incorrect", "error");
                    break;
                }
                this.player.setSystemVolume(volume.floatValue());
                execution.appendOutput("Volume value changed", "warn");
                break;
            }
            case "sh": 
            case "exit": 
            case "quit": {
                if (this.isPlayerOn()) {
                    this.player.shutdown();
                    this.player = null;
                }
                this.on = false;
                break;
            }
            case "k": {
                if (!this.isPlayerOn() || !cmd.hasOptions()) break;
                Number seekSec = cmd.getOptionAsNumber(0);
                if (seekSec == null) {
                    execution.appendOutput("Seek value incorrect", "error");
                    break;
                }
                this.player.seek(seekSec.doubleValue());
                break;
            }
            case "skf": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    String optionParam = cmd.getOptionAt(0);
                    SeekOption option = optionParam.equals("next") ? SeekOption.NEXT : (optionParam.equals("prev") ? SeekOption.PREV : null);
                    Number jumps = cmd.getOptionAsNumber(1);
                    if (cmd.getOptionsCount() > 1 && jumps == null) {
                        execution.appendOutput("Seek value incorrect", "error");
                    } else if (jumps == null && option == null) {
                        execution.appendOutput("Option value incorrect", "error");
                    } else if (jumps == null) {
                        this.player.seekFolder(option);
                    } else if (jumps.intValue() < 0) {
                        execution.appendOutput("Jumps value incorrect", "error");
                    } else {
                        this.player.seekFolder(option, jumps.intValue());
                    }
                } else {
                    this.player.seekFolder(SeekOption.NEXT);
                }
                this.showSongInfo(this.player.getCurrent(), execution);
                break;
            }
            case "u": {
                if (this.player == null) break;
                this.player.reloadTracks();
                break;
            }
            case "g": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number gotoSec = cmd.getOptionAsNumber(0);
                if (gotoSec == null) {
                    execution.appendOutput("Go to value incorrect", "error");
                    break;
                }
                this.player.gotoSecond(gotoSec.doubleValue());
                break;
            }
            case "c": {
                int count = this.player.getSongsCount();
                if (this.player == null) break;
                execution.appendOutput(this.player.getSongsCount(), "info");
                break;
            }
            case "d": {
                if (this.player == null) break;
                execution.appendOutput(this.player.getCurrent().getFormattedDuration(), "info");
                break;
            }
            case "cover": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    execution.appendOutput("Current track unavailable", "error");
                    break;
                }
                if (!current.hasCover()) {
                    execution.appendOutput("Current song don't have cover", "error");
                    break;
                }
                if (cmd.hasOptions()) {
                    File folderPath = new File(cmd.getOptionAt(0));
                    if (!folderPath.exists()) {
                        folderPath = this.player.getRootFolder();
                    }
                    File fileCover = new File(folderPath, "cover-" + current.getTitle() + ".png");
                    fileCover.createNewFile();
                    Files.write(fileCover.toPath(), current.getCoverData(), StandardOpenOption.WRITE);
                    execution.appendOutput("Created cover with name " + fileCover.getName(), "warn");
                    break;
                }
                execution.appendOutput("Cover path not defined", "error");
                break;
            }
            case "info": {
                if (this.player.hasSounds() && this.player.getCurrent() != null) {
                    this.showSongInfo(this.player.getCurrent(), execution);
                    break;
                }
                execution.appendOutput("No song available", "warn");
                break;
            }
            case "prog": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    execution.appendOutput("Current track unavailable", "error");
                    break;
                }
                String formattedProgress = current.getFormattedProgress();
                String formattedDuration = current.getFormattedDuration();
                execution.appendOutput(formattedProgress + "/" + formattedDuration, "warn");
                break;
            }
            case "clear": 
            case "cls": {
                this.clearConsole();
                break;
            }
            case "format": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    execution.appendOutput("Current track unavailable", "error");
                    break;
                }
                String className = current.getClass().getSimpleName();
                execution.appendOutput(className.substring(0, className.length() - 5).toLowerCase(), "warn");
                break;
            }
            case "title": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    execution.appendOutput("Current track unavailable", "error");
                    break;
                }
                execution.appendOutput(current.getTitle(), "warn");
                break;
            }
            case "name": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    execution.appendOutput("Current track unavailable", "error");
                    break;
                }
                execution.appendOutput(current.getDataSourceAsFile().getName(), "warn");
                break;
            }
            case "h": 
            case "help": {
                this.printHelp(execution);
                break;
            }
            case "system": 
            case "sys": {
                if (!cmd.hasOptions()) break;
                this.execSysCommand(cmd.getOptionsAsString());
                break;
            }
            case "sn": {
                if (!this.isPlayerOn()) break;
                execution.appendOutput(TrackUtil.getSongInfo(this.player.getNext()), "warn");
                break;
            }
            case "sp": {
                if (!this.isPlayerOn()) break;
                execution.appendOutput(TrackUtil.getSongInfo(this.player.getPrevious()), "warn");
                break;
            }
            case "pf": {
                Number fldIndex;
                if (!this.isPlayerOn() || !cmd.hasOptions() || (fldIndex = cmd.getOptionAsNumber(0)) == null || fldIndex.intValue() <= 0) break;
                this.player.playFolder(fldIndex.intValue() - 1);
                this.showSongInfo(this.player.getCurrent(), execution);
                break;
            }
            case "load": {
                if (!cmd.hasOptions()) break;
                File folder = new File(cmd.getOptionAt(0));
                if (folder.exists()) {
                    if (folder.isDirectory()) {
                        if (folder.list() == null) {
                            execution.appendOutput("Folder is empty", "error");
                            break;
                        }
                        MusicPlayer newMusicPlayer = new MusicPlayer(folder);
                        newMusicPlayer.start();
                        if (this.isPlayerOn()) {
                            this.player.shutdown();
                        }
                        this.player = newMusicPlayer;
                        break;
                    }
                    execution.appendOutput("Path not be a directory", "error");
                    break;
                }
                execution.appendOutput("Folder not exists", "error");
                break;
            }
            case "arts": {
                if (this.player.isAlive() && this.player.hasSounds()) {
                    List<Artist> listArtists = this.player.getArtists();
                    for (Artist artist : listArtists) {
                        execution.appendOutput(artist.getName(), "info");
                    }
                    execution.appendOutput("------------------------------", "info");
                    execution.appendOutput("Total: " + listArtists.size(), "info");
                    break;
                }
                execution.appendOutput("The player is not active", "warn");
                break;
            }
            case "albs": {
                if (this.player.isAlive() && this.player.hasSounds()) {
                    List<Album> listAlbums = this.player.getAlbums();
                    for (Album album : listAlbums) {
                        execution.appendOutput(album.getName(), "info");
                    }
                    execution.appendOutput("------------------------------", "info");
                    execution.appendOutput("Total: " + listAlbums.size(), "info");
                    break;
                }
                execution.appendOutput("The player is not active", "warn");
                break;
            }
            case "chm": {
                if (cmd.hasOptions()) {
                    String firstOpt = cmd.getOptionAt(0);
                    ConsoleRunner consoleRunner = (ConsoleRunner)Global.getInstance().getVar(GlobalVar.RUNNER);
                    if (firstOpt.equalsIgnoreCase(RunnerMode.LOCAL.name())) {
                        if (consoleRunner instanceof DaemonRunner) {
                            LocalRunner localRunner = new LocalRunner(this.player);
                            TaskRunner.execute(localRunner);
                            Global.getInstance().setVar(GlobalVar.RUNNER, localRunner);
                            ((DaemonRunner)consoleRunner).shutdown();
                            execution.appendOutput("MuPlayer changed from DAEMON to LOCAL mode!", "info");
                            break;
                        }
                        execution.appendOutput("MuPlayer already working with LOCAL mode", "warn");
                        break;
                    }
                    if (firstOpt.equalsIgnoreCase(RunnerMode.DAEMON.name())) {
                        if (consoleRunner instanceof LocalRunner) {
                            DaemonRunner daemonRunner = new DaemonRunner(this.player);
                            TaskRunner.execute(daemonRunner);
                            Global.getInstance().setVar(GlobalVar.RUNNER, daemonRunner);
                            ((LocalRunner)consoleRunner).shutdown();
                            execution.appendOutput("MuPlayer changed from LOCAL to DAEMON mode!", "info");
                            break;
                        }
                        execution.appendOutput("MuPlayer already working with DAEMON mode", "warn");
                        break;
                    }
                    execution.appendOutput("Option selected unknown, the options must be LOCAL or DAEMON", "warn");
                    break;
                }
                execution.appendOutput("No options selected, the options must be LOCAL or DAEMON", "warn");
                break;
            }
            default: {
                execution.appendOutput("Comando desconocido, inserte el comando \"h\" o \"help\"\npara desplegar el men\u00fa de ayuda.", "warn");
            }
        }
        return execution;
    }
}

