/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer;

import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.muplayer.console.runner.ConsoleRunner;
import org.muplayer.console.runner.DaemonRunner;
import org.muplayer.console.runner.LocalRunner;
import org.muplayer.properties.config.ConfigInfo;
import org.muplayer.properties.msg.MessagesInfo;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.muplayer.thread.TaskRunner;
import org.muplayer.util.IOUtil;

public class MuPlayer {
    private static final Logger log = Logger.getLogger(MuPlayer.class.getName());

    public static void main(String[] args) {
        try {
            MuPlayer.loadLogConfig();
            ConsoleRunner consoleRunner = null;
            if (args.length == 0) {
                String defaultRootPath = ConfigInfo.getInstance().getProperty("music-folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                }
                consoleRunner = new LocalRunner(defaultRootPath);
            } else {
                switch (args.length) {
                    case 1: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                        }
                        consoleRunner = new LocalRunner(firstArg);
                        break;
                    }
                    case 2: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            if (firstArg.equals("-l")) {
                                consoleRunner = new LocalRunner(args[1]);
                                break;
                            }
                            if (firstArg.equals("-d")) {
                                consoleRunner = new DaemonRunner(args[1]);
                                break;
                            }
                            throw new NullPointerException("Arg " + firstArg + "not recognized");
                        }
                        throw new NullPointerException("Arg " + firstArg + "not recognized");
                    }
                }
            }
            if (consoleRunner != null) {
                TaskRunner.execute(consoleRunner);
                Global.getInstance().setVar(GlobalVar.RUNNER, consoleRunner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Error on MuPlayer class: " + e);
        }
    }

    private static void loadLogConfig() {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(IOUtil.getArrayStreamFromRes("/log-config.properties"));
        }
        catch (IOException e) {
            log.warning("Cannot load /log-config.properties");
        }
    }
}

