/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.muplayer.properties.AudioSupportInfo;
import org.muplayer.util.FileUtil;

public class AudioUtil {
    private static final float MAX_VOL = 0.855f;
    private static final float MIN_VOL = -80.0f;
    public static final float VOL_RANGE = 80.855f;
    public static final float MiDDLE_VOL = 40.4275f;
    private static final float DEFAULT_MIN_VOL = 0.0f;
    private static final float DEFAULT_MAX_VOL = 100.0f;
    private static final float DEFAULT_VOL_RANGE = 100.0f;

    private static float convertVolRangeToLineRange(float volume, float minLineVol, float maxLineVol) {
        float volRange = maxLineVol - minLineVol;
        float volScale = 1.0f / (100.0f / volRange);
        float result = volume * volScale + minLineVol;
        return result < minLineVol ? minLineVol : Math.min(result, maxLineVol);
    }

    private static float convertLineRangeToVolRange(float volume, float minLineVol, float maxLineVol) {
        float volRange = maxLineVol - minLineVol;
        float volScale = 1.0f / (100.0f / volRange);
        float result = (volume - minLineVol) / volScale;
        return result < 0.0f ? 0.0f : Math.min(result, 100.0f);
    }

    public static float convertVolRangeToLineRange(float volume) {
        return AudioUtil.convertVolRangeToLineRange(volume, -80.0f, 0.855f);
    }

    public static float convertLineRangeToVolRange(float volume) {
        return AudioUtil.convertLineRangeToVolRange(volume, -80.0f, 0.855f);
    }

    public static float convertVolRangeToLineRange(float volume, FloatControl control) {
        return AudioUtil.convertVolRangeToLineRange(volume, control.getMinimum(), control.getMaximum());
    }

    public static float convertLineRangeToVolRange(float volume, FloatControl control) {
        return AudioUtil.convertLineRangeToVolRange(volume, control.getMinimum(), control.getMaximum());
    }

    public static AudioInputStream instanceStream(AudioFileReader audioReader, Object source) throws IOException, UnsupportedAudioFileException {
        if (source instanceof URL) {
            return audioReader.getAudioInputStream((URL)source);
        }
        if (source instanceof InputStream) {
            return audioReader.getAudioInputStream((InputStream)source);
        }
        return audioReader.getAudioInputStream((File)source);
    }

    public static AudioFileFormat getAudioFileFormat(Object dataSource) throws UnsupportedAudioFileException, IOException {
        if (dataSource != null) {
            if (dataSource instanceof File) {
                return AudioSystem.getAudioFileFormat((File)dataSource);
            }
            if (dataSource instanceof InputStream) {
                return AudioSystem.getAudioFileFormat((InputStream)dataSource);
            }
            return AudioSystem.getAudioFileFormat((URL)dataSource);
        }
        return null;
    }

    public static boolean isSupportedFile(File trackFile) {
        String formatName = FileUtil.getFormatName(trackFile.getName());
        return AudioSupportInfo.getInstance().getProperty(formatName) != null;
    }

    public static boolean isSupportedFile(Path track) {
        return AudioUtil.isSupportedFile(track.toFile());
    }

    public static boolean isSupportedFile(String trackPath) {
        return AudioUtil.isSupportedFile(new File(trackPath));
    }

    public static AudioFormat getPcmFormatByMpeg(AudioFormat baseFormat) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getFrameRate() * 1000.0f, baseFormat.isBigEndian());
    }

    public static AudioFormat getPcmFormatByFlac(AudioFormat baseFormat) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), baseFormat.getSampleSizeInBits(), baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), baseFormat.isBigEndian());
    }

    public static AudioInputStream decodeToPcm(AudioFormat baseFormat, AudioInputStream encodedAis) {
        AudioFormat decodedFormat = AudioUtil.getPcmFormatByMpeg(baseFormat);
        if (AudioSystem.isConversionSupported(decodedFormat, baseFormat)) {
            return AudioSystem.getAudioInputStream(decodedFormat, encodedAis);
        }
        return null;
    }

    public static AudioInputStream decodeToPcm(AudioInputStream sourceAis) {
        return AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, sourceAis);
    }
}

