/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.muplayer.properties.PropertiesFilesInfo;
import org.muplayer.util.IOUtil;

public class ConfigInfo {
    private final File fileProps = new File(PropertiesFilesInfo.CONFIG_FILE_PATH);
    private Properties props = new Properties();
    private static ConfigInfo singleton;

    public static ConfigInfo getInstance() {
        if (singleton == null) {
            singleton = new ConfigInfo();
        }
        return singleton;
    }

    private ConfigInfo() {
        if (!this.fileProps.exists()) {
            try {
                this.fileProps.createNewFile();
                this.saveData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.loadData();
        }
    }

    private void loadData() {
        try {
            this.props = new Properties();
            this.props.load(IOUtil.getBufferedReader(this.fileProps));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveData() {
        try {
            this.props.store(new FileOutputStream(this.fileProps), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        return this.props.getProperty(key);
    }
}

