/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.player;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.player.PlayerData;
import org.muplayer.audio.player.PlayerInfo;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.states.TrackState;
import org.muplayer.audio.track.states.UnknownState;
import org.muplayer.exception.MuPlayerException;
import org.muplayer.interfaces.ReportableTrack;
import org.muplayer.listener.PlayerListener;
import org.muplayer.model.Album;
import org.muplayer.model.Artist;
import org.muplayer.model.SeekOption;
import org.muplayer.model.TrackSearch;
import org.muplayer.thread.ListenerRunner;
import org.muplayer.thread.TaskRunner;
import org.muplayer.thread.ThreadUtil;
import org.muplayer.util.AudioUtil;
import org.muplayer.util.FileUtil;
import org.muplayer.util.IOUtil;

public class MusicPlayer
extends Player {
    private static final Logger log = Logger.getLogger(MusicPlayer.class.getName());
    private volatile File rootFolder;
    private volatile Track current;
    private final List<Track> listTracks;
    private final List<File> listFolders;
    private final List<PlayerListener> listListeners;
    private final PlayerData playerData;
    private static final int DEFAULT_INITIAL_LIST_CAPACITY = 500;

    public MusicPlayer() throws FileNotFoundException {
        this((File)null);
    }

    public MusicPlayer(File rootFolder) throws FileNotFoundException {
        this.rootFolder = rootFolder;
        this.listTracks = new ArrayList<Track>(500);
        this.listFolders = new ArrayList<File>(500);
        this.listListeners = new ArrayList<PlayerListener>();
        this.playerData = new PlayerData();
        this.checkRootFolder();
        this.setName("ThreadPlayer " + this.getId());
    }

    public MusicPlayer(String folderPath) throws FileNotFoundException {
        this(new File(folderPath));
    }

    private void checkRootFolder() throws FileNotFoundException {
        if (this.rootFolder != null) {
            if (!this.rootFolder.exists()) {
                throw new FileNotFoundException(this.rootFolder.getPath());
            }
            this.loadTracks(this.rootFolder);
            this.sortTracks();
        }
    }

    private void loadTracks(File folderToLoad) {
        if (!Files.isReadable(folderToLoad.toPath())) {
            throw new MuPlayerException("folderToLoad is not readable");
        }
        File[] fldFiles = folderToLoad.listFiles();
        if (fldFiles != null) {
            boolean hasTracks = false;
            for (int i = 0; i < fldFiles.length; ++i) {
                File file = fldFiles[i];
                if (file.isDirectory()) {
                    this.loadTracks(file);
                    continue;
                }
                Track track = Track.getTrack(FileUtil.getPath(file), this);
                if (track == null) continue;
                this.listTracks.add(track);
                hasTracks = true;
            }
            if (hasTracks && this.listFolders.parallelStream().noneMatch(folder -> folder.getPath().equals(folderToLoad.getPath()))) {
                this.listFolders.add(folderToLoad);
            }
        }
    }

    private void loadTracks(List<File> listFiles) {
        listFiles.forEach(file -> {
            if (file.isDirectory()) {
                this.loadTracks((File)file);
            } else {
                Track track = Track.getTrack(FileUtil.getPath(file), this);
                if (track != null) {
                    this.listTracks.add(track);
                }
            }
        });
    }

    private void sortTracks() {
        this.listTracks.sort((o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            File dataSource1 = o1.getDataSourceAsFile();
            File dataSource2 = o2.getDataSourceAsFile();
            if (dataSource1 == null || dataSource2 == null) {
                return 0;
            }
            return dataSource1.getPath().compareTo(dataSource2.getPath());
        });
        this.listFolders.sort(Comparator.comparing(File::getPath));
    }

    private int getFolderIndex() {
        File dataSource = this.current.getDataSourceAsFile();
        File currentParent = this.current != null ? dataSource.getParentFile() : null;
        return currentParent != null ? this.listFolders.indexOf(currentParent) : -1;
    }

    private Track getValidTrackBy(int index) {
        Track track = this.listTracks.get(index);
        try {
            track.validateTrack();
            return track;
        }
        catch (Exception e) {
            log.info("Error on getTrack: " + (String)(track != null ? track.getTitle() : "Unknown; index=" + this.playerData.getTrackIndex()));
            return null;
        }
    }

    private String getThreadName() {
        File dataSource = this.current.getDataSourceAsFile();
        String trackName = dataSource != null ? dataSource.getName() : dataSource.toString();
        int strLimit = Math.min(trackName.length(), 10);
        return "ThreadTrack: " + trackName.substring(0, strLimit);
    }

    private void startTrackThread() {
        if (this.current != null) {
            this.current.setName(this.getThreadName());
            this.current.setVolume(this.playerData.getVolume());
            if (this.isMute()) {
                this.current.mute();
            }
            this.current.start();
        }
    }

    private synchronized void freezePlayer() {
        ThreadUtil.freezeThread(this);
    }

    private void killCurrent() {
        if (this.current.isPaused() || this.current.isStopped()) {
            this.current.interrupt();
        } else {
            this.current.kill();
        }
    }

    private void shutdownCurrent() {
        if (this.current != null) {
            this.killCurrent();
            this.listTracks.set(this.playerData.getTrackIndex(), Track.getTrack(this.current.getDataSourceAsFile(), this));
            this.current = null;
        }
    }

    private void waitForSongs() {
        while (this.playerData.isOn() && this.getSongsCount() == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private TrackSearch findFirstIn(String folderPath) {
        File parentFile = new File(folderPath);
        for (int i = 0; i < this.listTracks.size(); ++i) {
            Track track = this.listTracks.get(i);
            File dataSource = track.getDataSourceAsFile();
            if (dataSource == null || !dataSource.getParentFile().equals(parentFile)) continue;
            return new TrackSearch(track, i);
        }
        return null;
    }

    private int seekToFolder(String folderPath) {
        File parentFile = new File(folderPath);
        int trackCount = this.listTracks.size();
        int newTrackIndex = -1;
        for (int i = 0; i < trackCount; ++i) {
            Track track = this.listTracks.get(i);
            File fileTrack = track.getDataSourceAsFile();
            if (fileTrack == null || !fileTrack.getParentFile().equals(parentFile)) continue;
            newTrackIndex = i;
            break;
        }
        return newTrackIndex;
    }

    private void startPlaying() {
        this.playerData.setOn(true);
        this.waitForSongs();
        this.playNext();
    }

    private void playFolderSongs(String fldPath) {
        for (int i = 0; i < this.listTracks.size(); ++i) {
            Track track = this.listTracks.get(i);
            File dataSource = track.getDataSourceAsFile();
            if (dataSource == null || !dataSource.getParent().equals(fldPath)) continue;
            this.play(i);
            break;
        }
    }

    private synchronized void changeTrack(SeekOption seekOption) {
        int currentIndex = this.playerData.getTrackIndex();
        int newIndex = seekOption == SeekOption.NEXT ? (currentIndex == this.listTracks.size() - 1 ? 0 : currentIndex + 1) : (currentIndex == 0 ? this.listTracks.size() - 1 : currentIndex - 1);
        this.changeTrack(newIndex);
    }

    private synchronized void changeTrack(int trackIndex) {
        this.shutdownCurrent();
        this.playerData.setTrackIndex(trackIndex);
        this.current = this.getValidTrackBy(this.playerData.getTrackIndex());
        this.startTrackThread();
        this.loadListenerMethod("onSongChange", this.current);
    }

    private synchronized void changeTrack(TrackSearch trackSearch) {
        if (trackSearch != null) {
            this.shutdownCurrent();
            this.playerData.setTrackIndex(trackSearch.getIndex());
            this.current = trackSearch.getTrack();
            this.startTrackThread();
            this.loadListenerMethod("onSongChange", this.current);
        }
    }

    public void loadListenerMethod(String methodName, Track track) {
        if (!this.listListeners.isEmpty()) {
            TaskRunner.execute(new ListenerRunner(this.listListeners, methodName, track));
        }
    }

    private boolean existsFolder(String folderPath) {
        return this.listFolders.parallelStream().anyMatch(fp -> fp.getPath().equals(folderPath));
    }

    @Override
    public TrackState getCurrentTrackState() {
        return this.current == null ? new UnknownState(this.current) : this.current.getTrackState();
    }

    @Override
    public int getFoldersCount() {
        return this.listFolders.size();
    }

    @Override
    public File getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public List<File> getListFolders() {
        return this.listFolders;
    }

    @Override
    public synchronized void jumpTrack(int jumps, SeekOption option) {
        int newIndex;
        if (option == SeekOption.NEXT) {
            newIndex = this.playerData.getTrackIndex() + jumps;
            if (newIndex >= this.listTracks.size()) {
                newIndex = 0;
            }
        } else {
            newIndex = this.playerData.getTrackIndex() - jumps;
            if (newIndex < 0) {
                newIndex = this.listTracks.size() - 1;
            }
        }
        this.play(newIndex);
    }

    @Override
    public synchronized List<File> getListSoundFiles() {
        return this.listTracks.stream().filter(track -> track.getDataSourceAsFile() != null).map(track -> track.getDataSourceAsFile()).collect(Collectors.toList());
    }

    @Override
    public synchronized List<Track> getTracks() {
        return this.listTracks;
    }

    @Override
    public synchronized List<Artist> getArtists() {
        List<Track> listTracks = this.getTracks();
        HashSet setArtists = new HashSet(listTracks.size() + 1);
        listTracks.parallelStream().forEach(track -> {
            String artistName = track.getArtist() != null ? track.getArtist() : "Unknown";
            Set set = setArtists;
            synchronized (set) {
                Artist artist = setArtists.parallelStream().filter(art -> art.getName().equals(artistName)).findFirst().orElse(null);
                if (artist != null) {
                    artist.addTrack((ReportableTrack)track);
                } else {
                    artist = new Artist(artistName);
                    artist.addTrack((ReportableTrack)track);
                    setArtists.add(artist);
                }
            }
        });
        ArrayList<Artist> listArtists = new ArrayList<Artist>(setArtists);
        listArtists.sort(Comparator.comparing(Artist::getName));
        return listArtists;
    }

    @Override
    public synchronized List<Album> getAlbums() {
        List<Track> listTracks = this.getTracks();
        HashSet setAlbums = new HashSet(listTracks.size() + 1);
        listTracks.parallelStream().forEach(track -> {
            String albumName = track.getAlbum() != null ? track.getAlbum() : "Unknown";
            Set set = setAlbums;
            synchronized (set) {
                Album album = setAlbums.parallelStream().filter(alb -> alb.getName().equals(albumName)).findFirst().orElse(null);
                if (album != null) {
                    album.addTrack((ReportableTrack)track);
                } else {
                    album = new Album(albumName);
                    album.addTrack((ReportableTrack)track);
                    setAlbums.add(album);
                }
            }
        });
        ArrayList<Album> listAlbums = new ArrayList<Album>(setAlbums);
        listAlbums.sort(Comparator.comparing(Album::getName));
        return listAlbums;
    }

    @Override
    public synchronized void addPlayerListener(PlayerListener listener) {
        this.listListeners.add(listener);
    }

    @Override
    public synchronized List<PlayerListener> getListeners() {
        return this.listListeners;
    }

    @Override
    public synchronized void removePlayerListener(PlayerListener reference) {
        this.listListeners.removeIf(listener -> listener.equals(reference));
    }

    @Override
    public synchronized void removeAllListeners() {
        this.listListeners.clear();
    }

    @Override
    public synchronized void reloadTracks() {
        if (this.rootFolder != null) {
            int currentIndex = this.playerData.getTrackIndex();
            this.listTracks.clear();
            this.listFolders.clear();
            this.loadTracks(this.rootFolder);
            this.sortTracks();
            int songCount = this.getSongsCount();
            this.playerData.setTrackIndex(songCount > currentIndex ? currentIndex : songCount - 1);
        }
    }

    @Override
    public PlayerInfo getInfo() {
        return new PlayerInfo(this);
    }

    @Override
    public synchronized Track getCurrent() {
        return this.current;
    }

    @Override
    public synchronized Track getNext() {
        int trackIndex = this.playerData.getTrackIndex();
        int songsCount = this.getSongsCount();
        int nextIndex = trackIndex == -1 ? 0 : (trackIndex == songsCount - 1 ? 0 : trackIndex + 1);
        return this.listTracks.get(nextIndex);
    }

    @Override
    public synchronized Track getPrevious() {
        int trackIndex = this.playerData.getTrackIndex();
        int songsCount = this.getSongsCount();
        int prevIndex = trackIndex == -1 ? songsCount - 1 : (trackIndex == 0 ? songsCount - 1 : trackIndex - 1);
        return this.listTracks.get(prevIndex);
    }

    @Override
    public int getSongsCount() {
        return this.listTracks.size();
    }

    @Override
    public boolean hasSounds() {
        return !this.listTracks.isEmpty();
    }

    @Override
    public synchronized boolean isOn() {
        return this.playerData.isOn();
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.current != null && this.current.isPlaying();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.current != null && this.current.isPaused();
    }

    @Override
    public synchronized boolean isStopped() {
        return this.current != null && this.current.isStopped();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.current != null && this.current.isFinished();
    }

    @Override
    public synchronized boolean isMute() {
        return this.playerData.isMute();
    }

    @Override
    public synchronized void addMusic(Collection<File> soundCollection) {
        if (!soundCollection.isEmpty()) {
            soundCollection.forEach(this::loadTracks);
        }
    }

    @Override
    public synchronized void addMusic(File folderOrFile) {
        Track track;
        if (folderOrFile.isDirectory()) {
            if (this.rootFolder == null) {
                this.rootFolder = folderOrFile;
            }
            boolean validSort = !this.hasSounds();
            this.loadTracks(folderOrFile);
            if (validSort) {
                this.sortTracks();
            }
        } else if (AudioUtil.isSupportedFile(folderOrFile) && (track = Track.getTrack(folderOrFile, this)) != null) {
            this.listTracks.add(track);
            File parent = folderOrFile.getParentFile();
            if (this.listFolders.parallelStream().noneMatch(parent::equals)) {
                this.listFolders.add(parent);
            }
        }
    }

    @Override
    public synchronized void seekFolder(SeekOption param) {
        this.seekFolder(param, 1);
    }

    @Override
    public synchronized void seekFolder(SeekOption option, int jumps) {
        int folderIndex = this.getFolderIndex();
        if (folderIndex != -1) {
            int newFolderIndex;
            File parentToFind = option == SeekOption.NEXT ? this.listFolders.get((newFolderIndex = folderIndex + jumps) >= this.getFoldersCount() ? 0 : newFolderIndex) : this.listFolders.get((newFolderIndex = folderIndex - jumps) < 0 ? this.listFolders.size() - 1 : newFolderIndex);
            this.changeTrack(this.findFirstIn(parentToFind.getPath()));
        }
    }

    @Override
    public synchronized void play() {
        if (!this.isAlive()) {
            this.start();
        } else if (this.current != null) {
            this.current.play();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public void play(int index) {
        Track track;
        if (this.current != null) {
            this.shutdownCurrent();
        }
        if (index > -1 && index < this.getSongsCount() && (track = this.listTracks.get(index)) != null) {
            this.current = track;
            this.startTrackThread();
            this.playerData.setTrackIndex(index);
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void play(File track) {
        int indexOf = this.listTracks.indexOf(this.listTracks.parallelStream().filter(t -> t.getDataSourceAsFile() != null && t.getDataSourceAsFile().getPath().equals(track.getPath())).findFirst().orElse(null));
        if (indexOf == -1) {
            if (AudioUtil.isSupportedFile(track)) {
                this.listTracks.add(Track.getTrack(track, this));
                if (!this.existsFolder(track.getParent())) {
                    this.listFolders.add(track.getParentFile());
                }
            }
        } else {
            this.playerData.setTrackIndex(indexOf);
            if (this.current != null) {
                this.killCurrent();
            }
            this.current = this.listTracks.get(this.playerData.getTrackIndex());
            this.startTrackThread();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void play(String trackName) {
        int indexOf = -1;
        File trackFile = null;
        Track track = null;
        for (int i = 0; i < this.listTracks.size(); ++i) {
            track = this.listTracks.get(i);
            trackFile = track.getDataSourceAsFile();
            if (trackFile != null && trackFile.getName().equals(trackName)) {
                indexOf = i;
                break;
            }
            trackFile = null;
            track = null;
        }
        if (indexOf != -1) {
            this.playerData.setTrackIndex(indexOf);
            if (this.current != null) {
                this.killCurrent();
            }
            this.current = track;
            this.startTrackThread();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void pause() {
        if (this.current != null) {
            this.current.pause();
            this.loadListenerMethod("onPaused", this.current);
        }
    }

    @Override
    public synchronized void resumeTrack() {
        if (this.current != null) {
            this.current.resumeTrack();
            this.loadListenerMethod("onResumed", this.current);
        }
    }

    @Override
    public synchronized void stopTrack() {
        if (this.current != null) {
            this.current.stopTrack();
            this.loadListenerMethod("onStopped", this.current);
        }
    }

    @Override
    public synchronized void finish() {
        this.shutdown();
    }

    @Override
    public synchronized void seek(double seconds) {
        if (this.current != null) {
            try {
                this.current.seek(seconds);
                this.loadListenerMethod("onGotosecond", this.current);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void gotoSecond(double second) {
        if (this.current != null) {
            try {
                this.current.gotoSecond(second);
                this.loadListenerMethod("onGotosecond", this.current);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized float getVolume() {
        return this.current == null ? this.playerData.getVolume() : this.current.getVolume();
    }

    @Override
    public synchronized void setVolume(float volume) {
        this.playerData.setVolume(volume);
        if (this.current != null) {
            this.current.setVolume(volume);
        }
    }

    @Override
    public synchronized void mute() {
        this.playerData.setMute(true);
        if (this.current != null) {
            this.current.mute();
        }
    }

    @Override
    public synchronized void unMute() {
        if (this.playerData.isVolumeZero()) {
            this.playerData.setVolume(100.0f);
        } else {
            this.playerData.setMute(false);
        }
        if (this.current != null) {
            this.current.unMute();
        }
    }

    @Override
    public double getProgress() {
        return this.current == null ? 0.0 : this.current.getProgress();
    }

    @Override
    public long getDuration() {
        return this.listTracks.stream().map(Track::getDuration).reduce(Long::sum).orElse(0L);
    }

    @Override
    public synchronized void playNext() {
        this.changeTrack(SeekOption.NEXT);
    }

    @Override
    public synchronized void playPrevious() {
        this.changeTrack(SeekOption.PREV);
    }

    @Override
    public void playFolder(String path) {
        this.shutdownCurrent();
        this.playFolderSongs(path);
    }

    @Override
    public void playFolder(int folderIndex) {
        int foldersCount = this.getFoldersCount();
        if (folderIndex >= foldersCount) {
            folderIndex = foldersCount - 1;
        }
        int newIndex = this.seekToFolder(this.listFolders.get(folderIndex).getPath());
        this.changeTrack(newIndex);
    }

    @Override
    public synchronized void shutdown() {
        this.playerData.setOn(false);
        this.shutdownCurrent();
        this.interrupt();
        this.loadListenerMethod("onShutdown", null);
    }

    @Override
    public synchronized void run() {
        this.loadListenerMethod("onStarted", null);
        this.startPlaying();
        this.freezePlayer();
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(IOUtil.getArrayStreamFromRes("/muplayer-info.properties"));
        }
        catch (IOException e) {
            log.warning("Cannot load /muplayer-info.properties");
        }
    }
}

