/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.muplayer.audio.Track;
import org.muplayer.interfaces.PlayerControls;

public class TrackUtil {
    private static void appendSongData(StringBuilder sbTabs, StringBuilder sbInfo, String title, String data) {
    }

    public static String getSongInfo(Track track) {
        int i;
        StringBuilder sbInfo = new StringBuilder();
        String title = track.getTitle();
        String album = track.getAlbum();
        String artist = track.getArtist();
        String date = track.getDate();
        String duration = track.getFormattedDuration();
        String hasCover = track.hasCover() ? "Yes" : "No";
        String encoder = track.getEncoder();
        String bitrate = track.getBitrate();
        StringBuilder sbTabs = new StringBuilder();
        String currentLine = "Song: " + title;
        int biggerLenght = currentLine.length();
        sbInfo.append(currentLine).append('\n');
        if (album != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Album: " + album;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (artist != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Artist: " + artist;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (date != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Date: " + date;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (duration != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Duration: " + duration;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        sbTabs.append("    ");
        currentLine = sbTabs.toString() + "Has Cover: " + hasCover;
        if (biggerLenght < currentLine.length()) {
            biggerLenght = currentLine.length();
        }
        sbInfo.append(currentLine).append('\n');
        if (encoder != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Encoder: " + encoder;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (bitrate != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Bitrate: " + bitrate + " kbps";
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        sbTabs.delete(0, sbTabs.length());
        for (i = 0; i < biggerLenght; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n').append(sbInfo.toString());
        for (i = 0; i < biggerLenght; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n');
        return sbTabs.toString();
    }

    public static Constructor<? extends Track> getTrackClassConstructor(String formatClass, Class<?> ... paramsClasses) {
        try {
            Class<?> trackClass = Class.forName(formatClass);
            return trackClass.getConstructor(paramsClasses);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Track getTrackFromClass(String formatClass, File dataSource, PlayerControls player) {
        try {
            Constructor<? extends Track> constructor = TrackUtil.getTrackClassConstructor(formatClass, dataSource.getClass(), PlayerControls.class);
            return constructor != null ? constructor.newInstance(dataSource, player) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Track getTrackFromClass(String formatClass, InputStream dataSource, PlayerControls player) {
        try {
            Constructor<? extends Track> constructor = TrackUtil.getTrackClassConstructor(formatClass, dataSource.getClass(), PlayerControls.class);
            return constructor != null ? constructor.newInstance(dataSource, player) : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

