/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class AppInfo {
    private final Properties properties = new Properties();
    private static final AppInfo instance = new AppInfo();

    public static AppInfo getInstance() {
        return instance;
    }

    public AppInfo() {
        this.loadData();
    }

    private void loadData() {
        try {
            this.properties.load(this.getClass().getResourceAsStream("/muplayer-info.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key).toString();
    }

    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

