/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.thread;

import java.util.List;
import org.muplayer.audio.Track;
import org.muplayer.interfaces.PlayerListener;

public class ListenerRunner
implements Runnable {
    private final List<PlayerListener> listListeners;
    private final String methodName;
    private final Track track;

    public ListenerRunner(List<PlayerListener> listListeners, String methodName, Track track) {
        this.listListeners = listListeners;
        this.methodName = methodName;
        this.track = track;
    }

    @Override
    public void run() {
        switch (this.methodName) {
            case "onSongChange": {
                this.listListeners.parallelStream().forEach(listener -> listener.onSongChange(this.track));
                break;
            }
            case "onPlayed": {
                this.listListeners.parallelStream().forEach(listener -> listener.onPlayed(this.track));
                break;
            }
            case "onPlaying": {
                this.listListeners.parallelStream().forEach(listener -> listener.onPlaying(this.track));
                break;
            }
            case "onResumed": {
                this.listListeners.parallelStream().forEach(listener -> listener.onResumed(this.track));
                break;
            }
            case "onPaused": {
                this.listListeners.parallelStream().forEach(listener -> listener.onPaused(this.track));
                break;
            }
            case "onStarted": {
                this.listListeners.parallelStream().forEach(PlayerListener::onStarted);
                break;
            }
            case "onStopped": {
                this.listListeners.parallelStream().forEach(listener -> listener.onStopped(this.track));
                break;
            }
            case "onSeeked": {
                this.listListeners.parallelStream().forEach(listener -> listener.onSeeked(this.track));
                break;
            }
            case "onShutdown": {
                this.listListeners.parallelStream().forEach(PlayerListener::onShutdown);
            }
        }
    }
}

