/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import org.muplayer.audio.Player;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.ConsoleInterpreter;
import org.muplayer.properties.AppConfigInfo;
import org.muplayer.system.SysInfo;
import org.muplayer.thread.TaskRunner;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsolePlayer
extends Thread {
    protected Player player;
    protected final ConsoleInterpreter interpreter;
    protected final Scanner scanner;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsolePlayer() throws FileNotFoundException {
        this.player = new Player((File)null);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.scanner = new Scanner(System.in);
    }

    public ConsolePlayer(File rootFolder) throws FileNotFoundException {
        this.player = new Player(rootFolder);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.scanner = new Scanner(System.in);
    }

    public ConsolePlayer(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    public ConsolePlayer(Player player) throws FileNotFoundException {
        this.player = player;
        this.interpreter = new ConsoleInterpreter(player);
        this.scanner = new Scanner(System.in);
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger(this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public ConsoleExecution execCommand(String strCmd) {
        try {
            return this.interpreter.executeCommand(strCmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void run() {
        String appVersion = SysInfo.readVersion();
        Object msg = appVersion != null ? "MuPlayer v" + appVersion + " started..." : "MuPlayer started...";
        Logger.getLogger(this, msg).rawInfo();
        this.interpreter.setOn(true);
        while (this.interpreter.isOn()) {
            this.printHeader();
            this.execCommand(this.scanner.nextLine().trim());
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                String defaultRootPath = AppConfigInfo.getInstance().get("root_folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException("Property 'root_folder' must be configured.\nIf you want to load a folder path automatically, create a file called config.properties in the path of the jar file and set the root_folder property indicating the path of your music folder");
                }
                TaskRunner.execute(new ConsolePlayer(defaultRootPath));
            } else {
                TaskRunner.execute(new ConsolePlayer(args[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

