/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.format;

import com.sun.media.sound.AiffFileReader;
import com.sun.media.sound.AuFileReader;
import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.info.TrackIO;
import org.muplayer.interfaces.PlayerControl;
import org.muplayer.util.AudioUtil;
import org.muplayer.util.FileUtil;

public class PCMTrack
extends Track {
    private static final String WAVE = "wav";
    private static final String AIFF = "aiff";
    private static final String AIFC = "aifc";

    public PCMTrack(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource);
    }

    public PCMTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    public PCMTrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    public PCMTrack(File dataSource, PlayerControl player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public PCMTrack(InputStream inputStream, PlayerControl player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public PCMTrack(String trackPath, PlayerControl player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        SunFileReader audioReader;
        String extension;
        this.trackIO = new TrackIO();
        switch (extension = FileUtil.getFormatName(this.dataSource instanceof File ? ((File)this.dataSource).getName() : "")) {
            case "wav": {
                audioReader = new WaveFileReader();
                break;
            }
            case "aiff": 
            case "aifc": {
                audioReader = new AiffFileReader();
                break;
            }
            default: {
                audioReader = new AuFileReader();
            }
        }
        AudioInputStream trackStream = AudioUtil.instanceStream(audioReader, this.dataSource);
        this.trackIO.setAudioReader(audioReader);
        this.trackIO.setDecodedStream(trackStream);
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }
}

