/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.IOException;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.fix.Fix;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTagField;

public class VorbisCommentReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader");
    public static final int FIELD_VENDOR_LENGTH_POS = 0;
    public static final int FIELD_VENDOR_STRING_POS = 4;
    public static final int FIELD_VENDOR_LENGTH_LENGTH = 4;
    public static final int FIELD_USER_COMMENT_LIST_LENGTH = 4;
    public static final int FIELD_COMMENT_LENGTH_LENGTH = 4;
    private Fix fix;
    private static final int JAUDIOTAGGER_MAX_COMMENT_LENGTH = 10000000;

    public VorbisCommentReader() {
    }

    public VorbisCommentReader(Fix fix) {
        this.fix = fix;
    }

    public VorbisCommentTag read(byte[] rawdata, boolean isFramingBit) throws IOException, CannotReadException {
        VorbisCommentTag tag = new VorbisCommentTag();
        byte[] b = new byte[4];
        System.arraycopy(rawdata, 0, b, 0, 4);
        int pos = 4;
        int vendorStringLength = Utils.getIntLE(b);
        b = new byte[vendorStringLength];
        System.arraycopy(rawdata, pos, b, 0, vendorStringLength);
        tag.setVendor(new String(b, "UTF-8"));
        logger.info("Vendor is:" + tag.getVendor());
        b = new byte[4];
        System.arraycopy(rawdata, pos += vendorStringLength, b, 0, 4);
        pos += 4;
        int userComments = Utils.getIntLE(b);
        logger.info("Number of user comments:" + userComments);
        if (this.fix == Fix.FIX_OGG_VORBIS_COMMENT_NOT_COUNTING_EMPTY_COLUMNS) {
            ++userComments;
        }
        for (int i = 0; i < userComments; ++i) {
            b = new byte[4];
            System.arraycopy(rawdata, pos, b, 0, 4);
            pos += 4;
            int commentLength = Utils.getIntLE(b);
            logger.info("Next Comment Length:" + commentLength);
            if (commentLength > 10000000) {
                logger.warning(ErrorMessage.VORBIS_COMMENT_LENGTH_TOO_LARGE.getMsg(commentLength));
                break;
            }
            if (commentLength > rawdata.length) {
                logger.warning(ErrorMessage.VORBIS_COMMENT_LENGTH_LARGE_THAN_HEADER.getMsg(commentLength, rawdata.length));
                break;
            }
            b = new byte[commentLength];
            System.arraycopy(rawdata, pos, b, 0, commentLength);
            pos += commentLength;
            VorbisCommentTagField fieldComment = new VorbisCommentTagField(b);
            logger.info("Adding:" + fieldComment.getId());
            tag.addField(fieldComment);
        }
        if (isFramingBit && (rawdata[pos] & 1) != 1) {
            throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_FRAMING_BIT.getMsg(rawdata[pos] & 1));
        }
        return tag;
    }
}

