/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.info;

import org.muplayer.util.AudioUtil;

public class PlayerData {
    private volatile int trackIndex = -1;
    private volatile float currentVolume = DEFAULT_VOLUME;
    private volatile boolean on = false;
    private volatile boolean isMute = false;
    public static final float DEFAULT_VOLUME = AudioUtil.convertLineRangeToVolRange(40.4275f);

    public synchronized void increaseTrackIndex(int steps) {
        this.trackIndex += steps;
    }

    public synchronized void decreaseTrackIndex(int steps) {
        this.trackIndex -= steps;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public float getCurrentVolume() {
        return this.currentVolume;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void setTrackIndex(int trackIndex) {
        this.trackIndex = trackIndex;
    }

    public void setCurrentVolume(float currentVolume) {
        this.currentVolume = currentVolume;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerData)) {
            return false;
        }
        PlayerData other = (PlayerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTrackIndex() != other.getTrackIndex()) {
            return false;
        }
        if (Float.compare(this.getCurrentVolume(), other.getCurrentVolume()) != 0) {
            return false;
        }
        if (this.isOn() != other.isOn()) {
            return false;
        }
        return this.isMute() == other.isMute();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTrackIndex();
        result = result * 59 + Float.floatToIntBits(this.getCurrentVolume());
        result = result * 59 + (this.isOn() ? 79 : 97);
        result = result * 59 + (this.isMute() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PlayerData(trackIndex=" + this.getTrackIndex() + ", currentVolume=" + this.getCurrentVolume() + ", on=" + this.isOn() + ", isMute=" + this.isMute() + ")";
    }
}

