/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.system;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.NonBlockingReader;

public class NativeConsole {
    private final Terminal terminal = TerminalBuilder.builder().exec(true).system(true).jna(true).nativeSignals(true).dumb(true).jansi(true).paused(false).name("MuPlayer").build();
    private final NonBlockingReader reader;
    private final PrintWriter writer;

    public NativeConsole() throws IOException {
        this.terminal.enterRawMode();
        this.reader = this.terminal.reader();
        this.writer = this.terminal.writer();
    }

    public char readChar() throws IOException {
        return (char)this.reader.read();
    }

    public int readInt() throws IOException {
        return this.reader.read();
    }

    public String readLine() throws IOException {
        char[] buffer = new char[100];
        return new String(Arrays.copyOf(buffer, this.reader.readBuffered(buffer)));
    }

    public void write(char c) {
        this.writer.write(c);
    }

    public void write(int i) {
        this.writer.write(i);
    }

    public void write(String str) {
        this.writer.write(str);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }
}

