/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.format;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.util.AudioUtil;

public class MP3Track
extends Track {
    private final long frameSize;
    private final double frameDurationInSec;

    public MP3Track(File dataSource) throws IOException, UnsupportedAudioFileException, LineUnavailableException, InvalidAudioFrameException {
        this(dataSource, null);
    }

    public MP3Track(String trackPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException, InvalidAudioFrameException {
        this(new File(trackPath), null);
    }

    public MP3Track(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(inputStream, null);
    }

    public MP3Track(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        super(dataSource, player);
        MP3AudioHeader audioHeader = new MP3AudioHeader(dataSource);
        long audioStartByte = audioHeader.getMp3StartByte();
        long audioSize = dataSource.length() - audioStartByte;
        long frameCount = audioHeader.getNumberOfFrames();
        this.frameSize = audioSize / frameCount;
        this.frameDurationInSec = audioHeader.getPreciseTrackLength() / (double)frameCount;
    }

    public MP3Track(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
        this.frameSize = 0L;
        this.frameDurationInSec = 0.0;
    }

    public MP3Track(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        this(new File(trackPath), player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new MpegAudioFileReader();
        AudioInputStream soundAis = AudioUtil.instanceStream(this.audioReader, this.source);
        AudioFormat baseFormat = soundAis.getFormat();
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        this.trackStream = DecodeManager.decodeToPcm(baseFormat, soundAis);
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        double frameNeeded = seconds.doubleValue() / this.frameDurationInSec;
        return frameNeeded * (double)this.frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        return bytes.doubleValue() / (double)this.frameSize * this.frameDurationInSec;
    }
}

