/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.aucom.sound.AudioQuality;
import org.muplayer.audio.Player;
import org.muplayer.system.AudioHardware;
import org.muplayer.util.AudioUtil;

public class VolumeTest {
    static final Mixer.Info[] mixersInfo = AudioSystem.getMixerInfo();
    static Scanner scan = new Scanner(System.in);
    static final AudioFormat format = AudioQuality.HIGH;

    public static void main(String[] args) throws Exception {
        System.out.println(new Player("/home/martin/Escritorio/").getInfo().toString());
        System.out.println(AudioHardware.getMasterOutputVolume());
        Line masterLine = AudioHardware.getMasterOutputLine();
        masterLine.open();
        FloatControl volume = AudioHardware.getVolumeControl(masterLine);
        while (true) {
            float vol;
            if ((vol = scan.nextFloat()) > 100.0f) {
                vol = 100.0f;
            } else if (vol < 0.0f) {
                vol = 0.0f;
            }
            volume.setValue(AudioUtil.convertVolRangeToLineRange(vol, volume));
        }
    }

    public static Port getPortLine(Mixer portMixer) {
        int i;
        Port port = null;
        Line[] lines = portMixer.getSourceLines();
        for (i = 0; i < lines.length; ++i) {
            if (!lines[i].getClass().equals(Port.class)) continue;
            port = (Port)lines[i];
        }
        if (port == null) {
            lines = portMixer.getTargetLines();
        }
        for (i = 0; i < lines.length; ++i) {
            if (!lines[i].getClass().equals(Port.class)) continue;
            port = (Port)lines[i];
        }
        return port;
    }

    public static void setCtrl(Control ctl) {
        if (ctl.getType().toString().equals("Select")) {
            ((BooleanControl)ctl).setValue(true);
        }
        if (ctl.getType().toString().equals("Volume")) {
            FloatControl vol = (FloatControl)ctl;
            vol.setValue(0.0f);
        }
    }

    public static void setRecControlValue(Port inPort) throws Exception {
        inPort.open();
        Control[] controls = inPort.getControls();
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i] instanceof CompoundControl) {
                Control[] members = ((CompoundControl)controls[i]).getMemberControls();
                for (int j = 0; j < members.length; ++j) {
                    VolumeTest.setCtrl(members[j]);
                }
                continue;
            }
            VolumeTest.setCtrl(controls[i]);
        }
        inPort.close();
    }

    public static void adjustRecordingVolume(Port.Info portInfo) throws Exception {
        Port recPort = (Port)AudioSystem.getLine(portInfo);
        VolumeTest.setRecControlValue(recPort);
    }

    public static void showControls(Line inLine) throws Exception {
        inLine.open();
        System.out.println("\t\tAvailable controls:");
        LinkedList<Control> ctrls = new LinkedList<Control>(Arrays.asList(inLine.getControls()));
        for (Control ctrl : ctrls) {
            System.out.println("\t\t\t" + ctrl.toString());
            if (!(ctrl instanceof CompoundControl)) continue;
            CompoundControl cc = (CompoundControl)ctrl;
            LinkedList<Control> ictrls = new LinkedList<Control>(Arrays.asList(cc.getMemberControls()));
            for (Control ictrl : ictrls) {
                System.out.println("\t\t\t\t" + ictrl.toString());
            }
        }
        inLine.close();
    }

    private static void showLineInfo(List<Line.Info> listLinesInfo, Mixer mixer) throws Exception {
        for (Line.Info lineInfo : listLinesInfo) {
            if (lineInfo instanceof Port.Info) {
                Port.Info portInfo = (Port.Info)lineInfo;
                System.out.println("\t\tPort: " + portInfo.getName() + ", " + (portInfo.isSource() ? "source" : "target"));
                VolumeTest.showControls(mixer.getLine(lineInfo));
                continue;
            }
            if (!(lineInfo instanceof DataLine.Info)) continue;
            DataLine.Info dataLineInfo = (DataLine.Info)lineInfo;
            System.out.println("\t\tDataLine: " + dataLineInfo);
        }
    }

    public static void scanPortMixer(Mixer mixer) throws Exception {
        Mixer.Info mixerInfo = mixer.getMixerInfo();
        System.out.println("Found mixer: " + mixerInfo.getName());
        System.out.println("\tDescription: " + mixerInfo.getDescription());
        System.out.println("\tVendor: " + mixerInfo.getVendor());
        System.out.println("\tVersion: " + mixerInfo.getVersion());
        ArrayList<Line.Info> listSourceLineInfos = new ArrayList<Line.Info>(Arrays.asList(mixer.getSourceLineInfo()));
        ArrayList<Line.Info> listTargetLineInfos = new ArrayList<Line.Info>(Arrays.asList(mixer.getTargetLineInfo()));
        System.out.println("Source1 Line Supported:");
        VolumeTest.showLineInfo(listSourceLineInfos, mixer);
        System.out.println("Target Line Supported:");
        VolumeTest.showLineInfo(listTargetLineInfos, mixer);
        System.out.println("---------------------------");
    }

    public static Mixer getPortMixer() throws Exception {
        Mixer portMixer = null;
        for (int i = 0; i < mixersInfo.length; ++i) {
            portMixer = AudioSystem.getMixer(mixersInfo[i]);
            if (!portMixer.isLineSupported(new Line.Info(Port.class))) continue;
            VolumeTest.scanPortMixer(portMixer);
            break;
        }
        return portMixer;
    }

    public static void showArrayContent(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + ": " + array[i]);
        }
        System.out.println("--------------");
        System.out.print("ID: ");
    }

    public static Line chooseLine(Mixer mixer, Class<? extends DataLine> lineClazz) throws LineUnavailableException {
        Object[] linesInfo;
        Line line = null;
        Object[] objectArray = linesInfo = lineClazz.equals(SourceDataLine.class) ? mixer.getSourceLineInfo() : mixer.getTargetLineInfo();
        while (line == null) {
            VolumeTest.showArrayContent(linesInfo);
            int id = scan.nextInt();
            line = mixer.getLine((Line.Info)linesInfo[id]);
        }
        return line;
    }

    public static void showMixersInfo() {
        Arrays.stream(mixersInfo).forEach(info -> VolumeTest.showMixerInfo(AudioSystem.getMixer(info)));
    }

    public static void showMixerInfo(Mixer mixer) {
        boolean speakerSupport = mixer.isLineSupported(new Line.Info(SourceDataLine.class));
        boolean microSupport = mixer.isLineSupported(new Line.Info(TargetDataLine.class));
        boolean portSupport = mixer.isLineSupported(new Line.Info(Port.class));
        boolean clipSupport = mixer.isLineSupported(new Line.Info(Clip.class));
        StringBuilder sbMixer = new StringBuilder();
        sbMixer.append(mixer.getMixerInfo().getName()).append("\n\t; ").append(mixer.getMixerInfo().getDescription()).append("\n\t\t");
        if (speakerSupport) {
            sbMixer.append("; ").append("speaker supported");
        }
        if (microSupport) {
            sbMixer.append("; ").append("micro supported");
        }
        if (portSupport) {
            sbMixer.append("; ").append("port supported");
        }
        if (clipSupport) {
            sbMixer.append("; ").append("clip supported");
        }
        System.out.println(sbMixer.toString());
    }

    public static Mixer chooseMixer() {
        Mixer mixer = null;
        while (mixer == null) {
            VolumeTest.showArrayContent(mixersInfo);
            int mixerId = scan.nextInt();
            mixer = AudioSystem.getMixer(mixersInfo[mixerId]);
        }
        return mixer;
    }

    public static class SoundInfo {
        public static void main(String[] args) throws Exception {
            SoundInfo.showMixers();
        }

        public static void showMixers() {
            LinkedList<Mixer.Info> mixInfos = new LinkedList<Mixer.Info>(Arrays.asList(AudioSystem.getMixerInfo()));
            Line.Info sourceDLInfo = new Line.Info(SourceDataLine.class);
            Line.Info targetDLInfo = new Line.Info(TargetDataLine.class);
            Line.Info clipInfo = new Line.Info(Clip.class);
            Line.Info portInfo = new Line.Info(Port.class);
            for (Mixer.Info mixInfo : mixInfos) {
                Mixer mixer = AudioSystem.getMixer(mixInfo);
                Object support = ", supports ";
                if (mixer.isLineSupported(sourceDLInfo)) {
                    support = (String)support + "SourceDataLine ";
                }
                if (mixer.isLineSupported(clipInfo)) {
                    support = (String)support + "Clip ";
                }
                if (mixer.isLineSupported(targetDLInfo)) {
                    support = (String)support + "TargetDataLine ";
                }
                if (mixer.isLineSupported(portInfo)) {
                    support = (String)support + "Port ";
                }
                System.out.println("Mixer: " + mixInfo.getName() + (String)support + ", " + mixInfo.getDescription());
            }
        }
    }
}

