/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.info.SongData;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.audio.interfaces.PlayerListener;
import org.muplayer.audio.model.Album;
import org.muplayer.audio.model.Artist;
import org.muplayer.audio.model.SeekOption;
import org.muplayer.audio.model.TrackInfo;
import org.muplayer.audio.model.TrackSearch;
import org.muplayer.audio.trackstates.TrackState;
import org.muplayer.audio.trackstates.UnknownState;
import org.muplayer.audio.util.PlayerInfo;
import org.muplayer.exception.MuPlayerException;
import org.muplayer.thread.ListenerRunner;
import org.muplayer.thread.TaskRunner;
import org.muplayer.thread.ThreadManager;
import org.muplayer.util.AudioUtil;
import org.muplayer.util.FileUtil;
import org.muplayer.util.LineUtil;

public class Player
extends Thread
implements PlayerControls {
    private volatile File rootFolder;
    private volatile Track current;
    private final List<Track> listTracks;
    private final List<String> listFolderPaths;
    private final List<PlayerListener> listListeners;
    private volatile int trackIndex;
    private volatile float currentVolume;
    private volatile boolean on;
    private volatile boolean isMute;
    public static final float DEFAULT_VOLUME = AudioUtil.convertLineRangeToVolRange(40.4275f);
    private static final int DEFAULT_INITIAL_LIST_CAPACITY = 500;

    public Player() throws FileNotFoundException {
        this((File)null);
    }

    public Player(File rootFolder) throws FileNotFoundException {
        this.rootFolder = rootFolder;
        this.listTracks = new ArrayList<Track>(500);
        this.listFolderPaths = new ArrayList<String>(500);
        this.listListeners = new ArrayList<PlayerListener>();
        this.currentVolume = DEFAULT_VOLUME;
        this.on = false;
        this.isMute = false;
        this.checkRootFolder();
        this.setName("ThreadPlayer " + this.getId());
        this.trackIndex = -1;
    }

    private void checkRootFolder() throws FileNotFoundException {
        if (this.rootFolder != null) {
            if (!this.rootFolder.exists()) {
                throw new FileNotFoundException(this.rootFolder.getPath());
            }
            this.loadTracks(this.rootFolder);
            this.sortTracks();
        }
    }

    public Player(String folderPath) throws FileNotFoundException {
        this(new File(folderPath));
    }

    private void loadTracks(File folder) {
        if (!Files.isReadable(folder.toPath())) {
            throw new MuPlayerException("folder is not readable");
        }
        File[] fldFiles = folder.listFiles();
        if (fldFiles != null) {
            boolean hasTracks = false;
            for (int i = 0; i < fldFiles.length; ++i) {
                File file = fldFiles[i];
                if (file.isDirectory()) {
                    this.loadTracks(file);
                    continue;
                }
                Track track = Track.getTrack(FileUtil.getPath(file), this);
                if (track == null) continue;
                this.listTracks.add(track);
                hasTracks = true;
            }
            if (hasTracks) {
                try {
                    if (this.listFolderPaths.parallelStream().noneMatch(path -> {
                        try {
                            return path.equals(folder.getCanonicalPath());
                        }
                        catch (IOException e) {
                            return true;
                        }
                    })) {
                        this.listFolderPaths.add(folder.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadTracks(List<File> listFiles) {
        listFiles.forEach(file -> {
            if (file.isDirectory()) {
                this.loadTracks((File)file);
            } else {
                Track track = Track.getTrack(FileUtil.getPath(file), this);
                if (track != null) {
                    this.listTracks.add(track);
                }
            }
        });
    }

    private void sortTracks() {
        Comparator comparator = Comparator.naturalOrder();
        this.listTracks.sort((o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            File dataSource1 = o1.getDataSourceAsFile();
            File dataSource2 = o2.getDataSourceAsFile();
            if (dataSource1 == null || dataSource2 == null) {
                return 0;
            }
            return FileUtil.getPath(dataSource1).compareTo(FileUtil.getPath(dataSource2));
        });
        this.listFolderPaths.sort(comparator);
    }

    private int getFolderIndex() {
        File dataSource = this.current.getDataSourceAsFile();
        String currentParent = this.current != null ? dataSource.getParent() : null;
        return currentParent != null ? this.listFolderPaths.indexOf(currentParent) : -1;
    }

    private Track getTrackBy(int currentIndex, SeekOption param) {
        Track nextTrack = null;
        if (param == SeekOption.NEXT) {
            int nextIndex;
            for (int i = nextIndex = currentIndex == this.getSongsCount() - 1 || currentIndex < 0 ? 0 : currentIndex + 1; i < this.listTracks.size(); ++i) {
                nextTrack = this.listTracks.get(i);
                if (nextTrack == null) continue;
                try {
                    nextTrack.validateTrack();
                    this.trackIndex = i;
                    break;
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
            }
        } else {
            int nextIndex;
            for (int i = nextIndex = currentIndex == 0 ? this.getSongsCount() - 1 : currentIndex - 1; i >= 0; --i) {
                nextTrack = this.listTracks.get(i);
                if (nextTrack == null) continue;
                try {
                    nextTrack.validateTrack();
                    this.trackIndex = i;
                    break;
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
            }
        }
        return nextTrack;
    }

    private String getThreadName() {
        File dataSource = this.current.getDataSourceAsFile();
        String trackName = dataSource != null ? dataSource.getName() : dataSource.toString();
        int strLimit = Math.min(trackName.length(), 10);
        return "ThreadTrack: " + trackName.substring(0, strLimit);
    }

    private void startTrackThread() {
        if (this.current != null) {
            this.current.setName(this.getThreadName());
            this.current.setGain(this.isMute ? 0.0f : this.currentVolume);
            this.current.start();
        }
    }

    public void loadListenerMethod(String methodName, Track track) {
        if (!this.listListeners.isEmpty()) {
            TaskRunner.execute(new ListenerRunner(this.listListeners, methodName, track));
        }
    }

    private synchronized void freezePlayer() {
        ThreadManager.freezeThread(this);
    }

    private void shutdownCurrent() {
        if (this.current != null) {
            this.current.kill();
            this.listTracks.set(this.trackIndex, Track.getTrack(this.current.getDataSourceAsFile(), this));
            this.current = null;
        }
    }

    private void waitForSongs() {
        while (this.on && this.getSongsCount() == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private TrackSearch findFirstIn(String folderPath) {
        File parentFile = new File(folderPath);
        for (int i = 0; i < this.listTracks.size(); ++i) {
            Track track = this.listTracks.get(i);
            File dataSource = track.getDataSourceAsFile();
            if (dataSource == null || !dataSource.getParentFile().equals(parentFile)) continue;
            return new TrackSearch(track, i);
        }
        return null;
    }

    private int seekToFolder(String folderPath) {
        File parentFile = new File(folderPath);
        int trackCount = this.listTracks.size();
        int newTrackIndex = -1;
        for (int i = 0; i < trackCount; ++i) {
            Track track = this.listTracks.get(i);
            File fileTrack = track.getDataSourceAsFile();
            if (fileTrack == null || !fileTrack.getParentFile().equals(parentFile)) continue;
            newTrackIndex = i;
            break;
        }
        return newTrackIndex;
    }

    private void startPlaying() {
        this.on = true;
        this.waitForSongs();
        this.playNext();
    }

    private void playFolderSongs(String fldPath) {
        for (int i = 0; i < this.listTracks.size(); ++i) {
            Track track = this.listTracks.get(i);
            File dataSource = track.getDataSourceAsFile();
            if (dataSource == null || !dataSource.getParent().equals(fldPath)) continue;
            this.play(i);
            break;
        }
    }

    public boolean hasSounds() {
        return !this.listTracks.isEmpty();
    }

    public boolean isActive() {
        return this.isAlive() && this.hasSounds();
    }

    public boolean existsFolder(String folderPath) {
        return this.listFolderPaths.parallelStream().anyMatch(fp -> fp.equals(folderPath));
    }

    public boolean existsFolder(File folder) {
        return this.existsFolder(folder.getPath());
    }

    public boolean existsParent(String childPath) {
        return this.existsParent(new File(childPath));
    }

    public boolean existsParent(File child) {
        return this.existsFolder(child.getParent());
    }

    public TrackState getCurrentTrackState() {
        return this.current == null ? new UnknownState(this.current) : this.current.getTrackState();
    }

    public String getCurrentTrackStateToString() {
        return this.current == null ? "Unknown" : this.current.getStateToString();
    }

    public int getFoldersCount() {
        return this.listFolderPaths.size();
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public List<String> getListFolderPaths() {
        return this.listFolderPaths;
    }

    public synchronized void jumpTrack(int jumps, SeekOption option) {
        if (option == SeekOption.NEXT) {
            this.trackIndex += jumps;
            if (this.trackIndex >= this.listTracks.size()) {
                this.trackIndex = 0;
            }
        } else {
            this.trackIndex -= jumps;
            if (this.trackIndex < 0) {
                this.trackIndex = this.listTracks.size() - 1;
            }
        }
        this.play(this.trackIndex);
    }

    public synchronized List<File> getListSoundFiles() {
        return this.listTracks.stream().filter(track -> track.getDataSourceAsFile() != null).map(track -> track.getDataSourceAsFile()).collect(Collectors.toList());
    }

    public synchronized List<AudioTag> getTrackTags() {
        LinkedList<AudioTag> listTags = new LinkedList<AudioTag>();
        this.listTracks.forEach(track -> {
            try {
                AudioTag tag = new AudioTag(track.getDataSourceAsFile());
                if (tag.isValidFile()) {
                    listTags.add(tag);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return listTags;
    }

    public synchronized List<Track> getTracks() {
        return this.listTracks;
    }

    public synchronized List<TrackInfo> getTracksInfo() {
        ArrayList<TrackInfo> listInfo = new ArrayList<TrackInfo>(this.listTracks.size() + 1);
        this.listTracks.forEach(track -> {
            try {
                AudioTag tag = new AudioTag(track.getDataSourceAsFile());
                if (tag.isValidFile()) {
                    listInfo.add(new SongData(tag));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return listInfo;
    }

    public synchronized List<Artist> getArtists() {
        List<TrackInfo> listTracks = this.getTracksInfo();
        ArrayList<Artist> listArtists = new ArrayList<Artist>(listTracks.size() + 1);
        listTracks.parallelStream().forEach(track -> {
            String art = track.getArtist();
            if (art == null) {
                art = "Unknown";
            }
            List list = listArtists;
            synchronized (list) {
                String finalArt = art;
                Artist artist = listArtists.parallelStream().filter(a -> a.getName().equalsIgnoreCase(finalArt)).findFirst().orElse(null);
                if (artist == null) {
                    artist = new Artist();
                    artist.setName(finalArt);
                    listArtists.add(artist);
                }
                artist.addTrack((TrackInfo)track);
            }
        });
        listArtists.sort(Comparator.comparing(Artist::getName));
        return listArtists;
    }

    public synchronized List<Album> getAlbums() {
        List<TrackInfo> listTracks = this.getTracksInfo();
        ArrayList<Album> listAlbums = new ArrayList<Album>(listTracks.size() + 1);
        listTracks.parallelStream().forEach(track -> {
            String alb = track.getAlbum();
            if (alb == null) {
                alb = "Unknown";
            }
            List list = listAlbums;
            synchronized (list) {
                String finalAlb = alb;
                Album album = listAlbums.parallelStream().filter(a -> a.getName().equalsIgnoreCase(finalAlb)).findFirst().orElse(null);
                if (album == null) {
                    album = new Album();
                    album.setName(finalAlb);
                    listAlbums.add(album);
                }
                album.addTrack((TrackInfo)track);
            }
        });
        listAlbums.sort(Comparator.comparing(Album::getName));
        return listAlbums;
    }

    public synchronized void addPlayerListener(PlayerListener listener) {
        this.listListeners.add(listener);
    }

    public synchronized List<PlayerListener> getListeners() {
        return this.listListeners;
    }

    public synchronized void removePlayerListener(PlayerListener reference) {
        this.listListeners.removeIf(listener -> listener.equals(reference));
    }

    public synchronized void removeAllListeners() {
        this.listListeners.clear();
    }

    public synchronized void reloadTracks() {
        if (this.rootFolder != null) {
            int currentIndex = this.trackIndex;
            this.listTracks.clear();
            this.listFolderPaths.clear();
            this.loadTracks(this.rootFolder);
            this.sortTracks();
            int songCount = this.getSongsCount();
            this.trackIndex = songCount > currentIndex ? currentIndex : songCount - 1;
        }
    }

    public PlayerInfo getInfo() {
        return new PlayerInfo(this);
    }

    public synchronized Track getCurrent() {
        return this.current;
    }

    public synchronized TrackInfo getNext() {
        int songsCount = this.getSongsCount();
        int nextIndex = this.trackIndex == -1 ? 0 : (this.trackIndex == songsCount - 1 ? 0 : this.trackIndex + 1);
        return this.listTracks.get(nextIndex);
    }

    public synchronized TrackInfo getPrevious() {
        int songsCount = this.getSongsCount();
        int prevIndex = this.trackIndex == -1 ? songsCount - 1 : (this.trackIndex == 0 ? songsCount - 1 : this.trackIndex - 1);
        return this.listTracks.get(prevIndex);
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.current != null && this.current.isPlaying();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.current != null && this.current.isPaused();
    }

    @Override
    public synchronized boolean isStopped() {
        return this.current != null && this.current.isStopped();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.current != null && this.current.isFinished();
    }

    @Override
    public synchronized boolean isMute() {
        return this.isMute;
    }

    @Override
    public synchronized void addMusic(Collection<File> soundCollection) {
        if (!soundCollection.isEmpty()) {
            soundCollection.forEach(this::loadTracks);
        }
    }

    @Override
    public synchronized void addMusic(File musicFolder) {
        Track track;
        if (musicFolder.isDirectory()) {
            if (this.rootFolder == null) {
                this.rootFolder = musicFolder;
            }
            boolean validSort = !this.hasSounds();
            this.loadTracks(musicFolder);
            if (validSort) {
                this.sortTracks();
            }
        } else if (Track.isValidTrack(musicFolder) && (track = Track.getTrack(musicFolder, this)) != null) {
            this.listTracks.add(track);
            String parentPath = musicFolder.getParent();
            if (this.listFolderPaths.parallelStream().noneMatch(parentPath::equals)) {
                this.listFolderPaths.add(parentPath);
            }
        }
    }

    public int getSongsCount() {
        return this.listTracks.size();
    }

    public synchronized void seekFolder(SeekOption param) {
        this.seekFolder(param, 1);
    }

    public synchronized void seekFolder(SeekOption option, int jumps) {
        int newFolderIndex;
        String parentToFind;
        TrackSearch trackResult;
        int folderIndex = this.getFolderIndex();
        if (folderIndex != -1 && (trackResult = this.findFirstIn(parentToFind = option == SeekOption.NEXT ? this.listFolderPaths.get((newFolderIndex = folderIndex + jumps) >= this.getFoldersCount() ? 0 : newFolderIndex) : this.listFolderPaths.get((newFolderIndex = folderIndex - jumps) < 0 ? this.listFolderPaths.size() - 1 : newFolderIndex))) != null) {
            this.shutdownCurrent();
            this.trackIndex = option == SeekOption.NEXT ? trackResult.getIndex() - 1 : trackResult.getIndex() + 1;
            this.current = this.getTrackBy(this.trackIndex, option);
            this.startTrackThread();
            this.loadListenerMethod("onSongChange", this.current);
        }
    }

    @Override
    public synchronized void play() {
        if (!this.isAlive()) {
            this.start();
        } else if (this.current != null) {
            this.current.play();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    public void play(int index) {
        Track track;
        if (this.current != null) {
            this.shutdownCurrent();
        }
        if (index > -1 && index < this.getSongsCount() && (track = this.listTracks.get(index)) != null) {
            this.current = track;
            this.startTrackThread();
            this.trackIndex = index;
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void play(File track) {
        int indexOf = this.listTracks.indexOf(this.listTracks.parallelStream().filter(t -> t.getDataSourceAsFile() != null && t.getDataSourceAsFile().getPath().equals(track.getPath())).findFirst().orElse(null));
        if (indexOf == -1) {
            if (Track.isValidTrack(track)) {
                this.listTracks.add(Track.getTrack(track, this));
                if (!this.existsFolder(track.getParent())) {
                    this.listFolderPaths.add(track.getParent());
                }
            }
        } else {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = this.listTracks.get(this.trackIndex);
            this.startTrackThread();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void play(String trackName) {
        int indexOf = -1;
        File trackFile = null;
        Track track = null;
        for (int i = 0; i < this.listTracks.size(); ++i) {
            track = this.listTracks.get(i);
            trackFile = track.getDataSourceAsFile();
            if (trackFile != null && trackFile.getName().equals(trackName)) {
                indexOf = i;
                break;
            }
            trackFile = null;
            track = null;
        }
        if (indexOf != -1) {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = track;
            this.startTrackThread();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void pause() {
        if (this.current != null) {
            this.current.pause();
            this.loadListenerMethod("onPaused", this.current);
        }
    }

    @Override
    public synchronized void resumeTrack() {
        if (this.current != null) {
            this.current.resumeTrack();
            this.loadListenerMethod("onResumed", this.current);
        }
    }

    @Override
    public synchronized void stopTrack() throws Exception {
        if (this.current != null) {
            this.current.stopTrack();
            this.loadListenerMethod("onStopped", this.current);
        }
    }

    @Override
    public synchronized void finish() {
        this.shutdown();
    }

    @Override
    public synchronized void seek(double seconds) {
        if (this.current != null) {
            try {
                this.current.seek(seconds);
                this.loadListenerMethod("onGotosecond", this.current);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void gotoSecond(double second) {
        if (this.current != null) {
            try {
                this.current.gotoSecond(second);
                this.loadListenerMethod("onGotosecond", this.current);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized float getGain() {
        return this.current == null ? this.currentVolume : this.current.getGain();
    }

    @Override
    public synchronized void setGain(float volume) {
        this.currentVolume = volume;
        if (this.current != null) {
            this.current.setGain(volume);
        }
        this.isMute = this.currentVolume == 0.0f;
    }

    @Override
    public float getSystemVolume() {
        return LineUtil.getFormattedMasterVolume();
    }

    @Override
    public void setSystemVolume(float volume) {
        LineUtil.setFormattedMasterVolume(volume);
    }

    @Override
    public synchronized void mute() {
        this.isMute = true;
        if (this.current != null) {
            this.current.mute();
        }
    }

    @Override
    public synchronized void unmute() {
        this.isMute = false;
        if (this.current != null) {
            this.current.setGain(this.currentVolume);
        } else {
            this.currentVolume = 100.0f;
        }
    }

    @Override
    public double getProgress() {
        return this.current == null ? 0.0 : this.current.getProgress();
    }

    public String getFormattedProgress() {
        return this.current == null ? "00:00" : this.current.getFormattedProgress();
    }

    private synchronized void changeTrack(SeekOption seekOption) {
        this.shutdownCurrent();
        this.current = this.getTrackBy(this.trackIndex, seekOption);
        this.startTrackThread();
        this.loadListenerMethod("onSongChange", this.current);
    }

    @Override
    public synchronized void playNext() {
        this.changeTrack(SeekOption.NEXT);
    }

    @Override
    public synchronized void playPrevious() {
        this.changeTrack(SeekOption.PREV);
    }

    public void playFolder(String path) {
        this.shutdownCurrent();
        this.playFolderSongs(path);
    }

    public void playFolder(int folderIndex) {
        int foldersCount = this.getFoldersCount();
        if (folderIndex >= foldersCount) {
            folderIndex = foldersCount - 1;
        }
        this.shutdownCurrent();
        this.trackIndex = this.seekToFolder(this.listFolderPaths.get(folderIndex));
        this.current = this.getTrackBy(this.trackIndex - 1, SeekOption.NEXT);
        this.startTrackThread();
        this.loadListenerMethod("onSongChange", this.current);
    }

    @Override
    public synchronized void shutdown() {
        this.on = false;
        this.shutdownCurrent();
        this.interrupt();
        this.loadListenerMethod("onShutdown", null);
    }

    @Override
    public synchronized void run() {
        this.loadListenerMethod("onStarted", null);
        this.startPlaying();
        this.freezePlayer();
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(new FileInputStream("config.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

