/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsfStreamer {
    private void copyChunk(GUID guid, InputStream source, OutputStream destination) throws IOException {
        long chunkSize = Utils.readUINT64(source);
        destination.write(guid.getBytes());
        Utils.writeUINT64(chunkSize, destination);
        Utils.copy(source, destination, chunkSize - 24L);
    }

    public void createModifiedCopy(InputStream source, OutputStream dest, List<ChunkModifier> modifiers) throws IOException {
        byte[] fileHeader;
        ByteArrayOutputStream bos;
        byte[] reserved;
        long chunkCount;
        long headerSize;
        long chunkDiff;
        long totalDiff;
        GUID readGUID;
        ArrayList<ChunkModifier> modders = new ArrayList<ChunkModifier>();
        if (modifiers != null) {
            modders.addAll(modifiers);
        }
        if (GUID.GUID_HEADER.equals(readGUID = Utils.readGUID(source))) {
            totalDiff = 0L;
            chunkDiff = 0L;
            headerSize = Utils.readUINT64(source);
            chunkCount = Utils.readUINT32(source);
            reserved = new byte[]{(byte)(source.read() & 0xFF), (byte)(source.read() & 0xFF)};
            bos = new ByteArrayOutputStream();
            fileHeader = null;
            for (long i = 0L; i < chunkCount; ++i) {
                GUID curr = Utils.readGUID(source);
                if (GUID.GUID_FILE.equals(curr)) {
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    long size = Utils.readUINT64(source);
                    Utils.writeUINT64(size, tmp);
                    Utils.copy(source, tmp, size - 24L);
                    fileHeader = tmp.toByteArray();
                    continue;
                }
                boolean handled = false;
                for (int j = 0; j < modders.size() && !handled; ++j) {
                    if (!((ChunkModifier)modders.get(j)).isApplicable(curr)) continue;
                    ModificationResult result = ((ChunkModifier)modders.get(j)).modify(curr, source, bos);
                    chunkDiff += (long)result.getChunkCountDifference();
                    totalDiff += result.getByteDifference();
                    modders.remove(j);
                    handled = true;
                }
                if (handled) continue;
                this.copyChunk(curr, source, bos);
            }
            for (ChunkModifier curr : modders) {
                ModificationResult result = curr.modify(null, null, bos);
                chunkDiff += (long)result.getChunkCountDifference();
                totalDiff += result.getByteDifference();
            }
        } else {
            throw new IllegalArgumentException("No ASF header object.");
        }
        dest.write(readGUID.getBytes());
        Utils.writeUINT64(headerSize + totalDiff, dest);
        Utils.writeUINT32(chunkCount + chunkDiff, dest);
        dest.write(reserved);
        this.modifyFileHeader(new ByteArrayInputStream(fileHeader), dest, totalDiff);
        dest.write(bos.toByteArray());
        Utils.flush(source, dest);
    }

    private void modifyFileHeader(InputStream source, OutputStream destination, long fileSizeDiff) throws IOException {
        destination.write(GUID.GUID_FILE.getBytes());
        long chunkSize = Utils.readUINT64(source);
        Utils.writeUINT64(chunkSize, destination);
        destination.write(Utils.readGUID(source).getBytes());
        long fileSize = Utils.readUINT64(source);
        Utils.writeUINT64(fileSize + fileSizeDiff, destination);
        Utils.copy(source, destination, chunkSize - 48L);
    }
}

